/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression;

import java.util.Objects;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.LeafExpression;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Literal
extends LeafExpression {
    public static final Literal TRUE = new Literal(Source.EMPTY, Boolean.TRUE, DataTypes.BOOLEAN);
    public static final Literal FALSE = new Literal(Source.EMPTY, Boolean.FALSE, DataTypes.BOOLEAN);
    public static final Literal NULL = new Literal(Source.EMPTY, null, DataTypes.NULL);
    private final Object value;
    private final DataType dataType;

    public Literal(Source source, Object value, DataType dataType) {
        super(source);
        this.dataType = dataType;
        this.value = value;
    }

    @Override
    protected NodeInfo<? extends Literal> info() {
        return NodeInfo.create(this, Literal::new, this.value, this.dataType);
    }

    public Object value() {
        return this.value;
    }

    @Override
    public boolean foldable() {
        return true;
    }

    @Override
    public Nullability nullable() {
        return this.value == null ? Nullability.TRUE : Nullability.FALSE;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public boolean resolved() {
        return true;
    }

    @Override
    public Object fold() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dataType, this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Literal other = (Literal)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.dataType, other.dataType);
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public String nodeString() {
        return this.toString() + "[" + this.dataType + "]";
    }

    public static Literal of(Expression foldable) {
        if (!foldable.foldable()) {
            throw new QlIllegalArgumentException("Foldable expression required for Literal creation; received unfoldable " + foldable);
        }
        if (foldable instanceof Literal) {
            return (Literal)foldable;
        }
        return new Literal(foldable.source(), foldable.fold(), foldable.dataType());
    }

    public static Literal of(Expression source, Object value) {
        return new Literal(source.source(), value, source.dataType());
    }
}

