/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.archive.ArchiveFeatureSetUsage;
import org.elasticsearch.xpack.lucene.bwc.OldLuceneVersions;

public class ArchiveUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final XPackLicenseState licenseState;

    @Inject
    public ArchiveUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, XPackLicenseState licenseState) {
        super(XPackUsageFeatureAction.ARCHIVE.name(), transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
        this.licenseState = licenseState;
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        int numArchiveIndices = 0;
        for (IndexMetadata indexMetadata : state.metadata()) {
            if (!indexMetadata.getCreationVersion().isLegacyIndexVersion()) continue;
            ++numArchiveIndices;
        }
        listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureSet.Usage)new ArchiveFeatureSetUsage(OldLuceneVersions.ARCHIVE_FEATURE.checkWithoutTracking(this.licenseState), numArchiveIndices)));
    }
}

