/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.redact;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.grok.Grok;
import org.elasticsearch.grok.GrokBuiltinPatterns;
import org.elasticsearch.grok.GrokCaptureConfig;
import org.elasticsearch.grok.GrokCaptureExtracter;
import org.elasticsearch.grok.MatcherWatchdog;
import org.elasticsearch.grok.PatternBank;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.joni.Matcher;
import org.joni.Region;

public class RedactProcessor
extends AbstractProcessor {
    public static final LicensedFeature.Momentary REDACT_PROCESSOR_FEATURE = LicensedFeature.momentary(null, (String)"redact_processor", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final String TYPE = "redact";
    private static final Logger logger = LogManager.getLogger(RedactProcessor.class);
    private static final String DEFAULT_REDACTED_START = "<";
    private static final String DEFAULT_REDACTED_END = ">";
    protected static final String REDACT_KEY = "_redact";
    protected static final String IS_REDACTED_KEY = "_is_redacted";
    protected static final String METADATA_PATH_REDACT = "_ingest._redact";
    protected static final String METADATA_PATH_REDACT_IS_REDACTED = "_ingest._redact._is_redacted";
    private final String redactField;
    private final List<Grok> groks;
    private final boolean ignoreMissing;
    private final String redactedStartToken;
    private final String redactedEndToken;
    private final XPackLicenseState licenseState;
    private final boolean skipIfUnlicensed;
    private final boolean traceRedact;

    RedactProcessor(String tag, String description, PatternBank patternBank, List<String> matchPatterns, String redactField, boolean ignoreMissing, String redactedStartToken, String redactedEndToken, MatcherWatchdog matcherWatchdog, XPackLicenseState licenseState, boolean skipIfUnlicensed, boolean traceRedact) {
        super(tag, description);
        this.redactField = redactField;
        this.redactedStartToken = redactedStartToken;
        this.redactedEndToken = redactedEndToken;
        this.groks = new ArrayList<Grok>(matchPatterns.size());
        for (String matchPattern : matchPatterns) {
            this.groks.add(new Grok(patternBank, matchPattern, matcherWatchdog, arg_0 -> ((Logger)logger).debug(arg_0)));
        }
        this.ignoreMissing = ignoreMissing;
        if (!matchPatterns.isEmpty()) {
            new Grok(patternBank, matchPatterns.get(0), matcherWatchdog, arg_0 -> ((Logger)logger).warn(arg_0)).match("___nomatch___");
        }
        this.licenseState = licenseState;
        this.skipIfUnlicensed = skipIfUnlicensed;
        this.traceRedact = traceRedact;
    }

    public void extraValidation() throws Exception {
        if (!this.skipIfUnlicensed && !REDACT_PROCESSOR_FEATURE.check(this.licenseState)) {
            String message = LicenseUtils.newComplianceException((String)REDACT_PROCESSOR_FEATURE.getName()).getMessage();
            throw ConfigurationUtils.newConfigurationException((String)TYPE, (String)this.tag, (String)"skip_if_unlicensed", (String)message);
        }
    }

    public IngestDocument execute(IngestDocument ingestDocument) {
        if (!REDACT_PROCESSOR_FEATURE.check(this.licenseState)) {
            if (this.skipIfUnlicensed) {
                return ingestDocument;
            }
            throw LicenseUtils.newComplianceException((String)REDACT_PROCESSOR_FEATURE.getName());
        }
        String fieldValue = (String)ingestDocument.getFieldValue(this.redactField, String.class, true);
        if (fieldValue == null && this.ignoreMissing) {
            return ingestDocument;
        }
        if (fieldValue == null) {
            throw new IllegalArgumentException("field [" + this.redactField + "] is null or missing");
        }
        try {
            String redacted = RedactProcessor.matchRedact(fieldValue, this.groks, this.redactedStartToken, this.redactedEndToken);
            ingestDocument.setFieldValue(this.redactField, (Object)redacted);
            this.updateMetadataIfNecessary(ingestDocument, fieldValue, redacted);
            return ingestDocument;
        }
        catch (RuntimeException e) {
            throw new ElasticsearchTimeoutException("Grok pattern matching timed out", (Throwable)e, new Object[0]);
        }
    }

    public String getType() {
        return TYPE;
    }

    List<Grok> getGroks() {
        return this.groks;
    }

    boolean getSkipIfUnlicensed() {
        return this.skipIfUnlicensed;
    }

    static String matchRedact(String fieldValue, List<Grok> groks) {
        return RedactProcessor.matchRedact(fieldValue, groks, DEFAULT_REDACTED_START, DEFAULT_REDACTED_END);
    }

    static String matchRedact(String fieldValue, List<Grok> groks, String redactedStartToken, String redactedEndToken) {
        byte[] utf8Bytes = fieldValue.getBytes(StandardCharsets.UTF_8);
        RegionTrackingMatchExtractor extractor = new RegionTrackingMatchExtractor();
        for (Grok grok : groks) {
            String patternName = ((GrokCaptureConfig)grok.captureConfig().get(0)).name();
            extractor.setCurrentPatternName(patternName);
            RedactProcessor.matchRepeat(grok, utf8Bytes, extractor);
        }
        if (extractor.replacementPositions.isEmpty()) {
            return fieldValue;
        }
        return extractor.redactMatches(utf8Bytes, redactedStartToken, redactedEndToken);
    }

    private static void matchRepeat(Grok grok, byte[] utf8Bytes, RegionTrackingMatchExtractor extractor) {
        int result;
        Matcher matcher = grok.getCompiledExpression().matcher(utf8Bytes, 0, utf8Bytes.length);
        int offset = 0;
        int length = utf8Bytes.length;
        while ((result = matcher.search(offset, length, 0)) >= 0) {
            extractor.extract(utf8Bytes, 0, matcher.getEagerRegion());
            offset = matcher.getEnd() == offset ? ++offset : matcher.getEnd();
            if (offset != length) continue;
        }
    }

    private void updateMetadataIfNecessary(IngestDocument ingestDocument, String fieldValue, String redacted) {
        boolean isRedacted;
        if (!this.traceRedact || fieldValue == null) {
            return;
        }
        Boolean isRedactedMetadata = (Boolean)ingestDocument.getFieldValue(METADATA_PATH_REDACT_IS_REDACTED, Boolean.class, true);
        boolean alreadyRedacted = Boolean.TRUE.equals(isRedactedMetadata);
        boolean bl = isRedacted = !fieldValue.equals(redacted);
        if (!alreadyRedacted && isRedacted) {
            ingestDocument.setFieldValue(METADATA_PATH_REDACT_IS_REDACTED, (Object)true);
        }
    }

    static class RegionTrackingMatchExtractor
    implements GrokCaptureExtracter {
        private final List<Replacement> replacementPositions = new ArrayList<Replacement>();
        private String patternName;

        RegionTrackingMatchExtractor() {
        }

        void setCurrentPatternName(String patternName) {
            this.patternName = patternName;
        }

        public void extract(byte[] utf8Bytes, int offset, Region region) {
            assert (this.patternName != null);
            int number = 0;
            int matchOffset = offset + region.beg[number];
            int matchEnd = offset + region.end[number];
            this.replacementPositions.add(new Replacement(matchOffset, matchEnd, this.patternName));
        }

        String redactMatches(byte[] utf8Bytes, String redactStartToken, String redactEndToken) {
            List<Replacement> merged = RegionTrackingMatchExtractor.mergeOverlappingReplacements(this.replacementPositions);
            int longestPatternName = merged.stream().mapToInt(r -> r.patternName.getBytes(StandardCharsets.UTF_8).length).max().getAsInt();
            int maxPossibleLength = longestPatternName * merged.size() + utf8Bytes.length;
            byte[] redact = new byte[maxPossibleLength];
            int readOffset = 0;
            int writeOffset = 0;
            for (Replacement rep : merged) {
                int numBytesToWrite = rep.start - readOffset;
                System.arraycopy(utf8Bytes, readOffset, redact, writeOffset, numBytesToWrite);
                readOffset = rep.end;
                byte[] replacementText = (redactStartToken + rep.patternName + redactEndToken).getBytes(StandardCharsets.UTF_8);
                System.arraycopy(replacementText, 0, redact, writeOffset += numBytesToWrite, replacementText.length);
                writeOffset += replacementText.length;
            }
            int numBytesToWrite = utf8Bytes.length - readOffset;
            System.arraycopy(utf8Bytes, readOffset, redact, writeOffset, numBytesToWrite);
            return new String(redact, 0, writeOffset += numBytesToWrite, StandardCharsets.UTF_8);
        }

        static List<Replacement> mergeOverlappingReplacements(List<Replacement> replacementPositions) {
            if (replacementPositions.size() == 1) {
                return replacementPositions;
            }
            ArrayList<Replacement> result = new ArrayList<Replacement>();
            replacementPositions.sort(Comparator.comparingInt(a -> a.start));
            int current = 0;
            int next = 1;
            while (current < replacementPositions.size()) {
                Replacement head = replacementPositions.get(current);
                if (next >= replacementPositions.size() || head.end < replacementPositions.get((int)next).start) {
                    result.add(head);
                } else {
                    int previousRegionEnd;
                    do {
                        previousRegionEnd = replacementPositions.get((int)next).end;
                    } while (++next < replacementPositions.size() && previousRegionEnd >= replacementPositions.get((int)next).start);
                    result.add(RegionTrackingMatchExtractor.mergeLongestRegion(replacementPositions.subList(current, next)));
                }
                current = next++;
            }
            return result;
        }

        static Replacement mergeLongestRegion(List<Replacement> replacementPositions) {
            assert (replacementPositions.size() > 1);
            int longestIndex = 0;
            int endPos = replacementPositions.get((int)0).end;
            int maxLength = replacementPositions.get(0).length();
            for (int i = 1; i < replacementPositions.size(); ++i) {
                if (replacementPositions.get(i).length() > maxLength) {
                    maxLength = replacementPositions.get(i).length();
                    longestIndex = i;
                }
                endPos = Math.max(endPos, replacementPositions.get((int)i).end);
            }
            return new Replacement(replacementPositions.get((int)0).start, endPos, replacementPositions.get((int)longestIndex).patternName);
        }

        static class Replacement {
            int start;
            int end;
            final String patternName;

            Replacement(int start, int end, String patternName) {
                this.start = start;
                this.end = end;
                this.patternName = patternName;
            }

            int length() {
                return this.end - this.start;
            }

            public String toString() {
                return "Replacement{start=" + this.start + ", end=" + this.end + ", patternName='" + this.patternName + "'}";
            }
        }
    }

    public static final class Factory
    implements Processor.Factory {
        private final XPackLicenseState licenseState;
        private final MatcherWatchdog matcherWatchdog;

        public Factory(XPackLicenseState licenseState, MatcherWatchdog matcherWatchdog) {
            this.licenseState = licenseState;
            this.matcherWatchdog = matcherWatchdog;
        }

        public RedactProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            String matchField = ConfigurationUtils.readStringProperty((String)RedactProcessor.TYPE, (String)processorTag, config, (String)"field");
            List matchPatterns = ConfigurationUtils.readList((String)RedactProcessor.TYPE, (String)processorTag, config, (String)"patterns");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)RedactProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)true);
            boolean skipIfUnlicensed = ConfigurationUtils.readBooleanProperty((String)RedactProcessor.TYPE, (String)processorTag, config, (String)"skip_if_unlicensed", (boolean)false);
            String redactStart = ConfigurationUtils.readStringProperty((String)RedactProcessor.TYPE, (String)processorTag, config, (String)"prefix", (String)RedactProcessor.DEFAULT_REDACTED_START);
            String redactEnd = ConfigurationUtils.readStringProperty((String)RedactProcessor.TYPE, (String)processorTag, config, (String)"suffix", (String)RedactProcessor.DEFAULT_REDACTED_END);
            boolean traceRedact = ConfigurationUtils.readBooleanProperty((String)RedactProcessor.TYPE, (String)processorTag, config, (String)"trace_redact", (boolean)false);
            if (matchPatterns == null || matchPatterns.isEmpty()) {
                throw ConfigurationUtils.newConfigurationException((String)RedactProcessor.TYPE, (String)processorTag, (String)"patterns", (String)"List of patterns must not be empty");
            }
            Map customPatternBank = ConfigurationUtils.readOptionalMap((String)RedactProcessor.TYPE, (String)processorTag, config, (String)"pattern_definitions");
            try {
                return new RedactProcessor(processorTag, description, GrokBuiltinPatterns.ecsV1Patterns().extendWith(customPatternBank), matchPatterns, matchField, ignoreMissing, redactStart, redactEnd, this.matcherWatchdog, this.licenseState, skipIfUnlicensed, traceRedact);
            }
            catch (Exception e) {
                throw ConfigurationUtils.newConfigurationException((String)RedactProcessor.TYPE, (String)processorTag, (String)"patterns", (String)("Invalid regex pattern found in: " + matchPatterns + ". " + e.getMessage()));
            }
        }
    }
}

