/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.history;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkProcessor2;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.watcher.history.WatchRecord;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.watcher.watch.WatchStoreUtils;

public class HistoryStore {
    private static final Logger logger = LogManager.getLogger(HistoryStore.class);
    public static final Setting<ByteSizeValue> MAX_HISTORY_SIZE_SETTING = Setting.byteSizeSetting((String)"xpack.watcher.max.history.record.size", (ByteSizeValue)ByteSizeValue.ofMb((long)10L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final BulkProcessor2 bulkProcessor;
    private final ByteSizeValue maxHistoryRecordSize;

    public HistoryStore(BulkProcessor2 bulkProcessor, Settings settings) {
        this.bulkProcessor = bulkProcessor;
        this.maxHistoryRecordSize = (ByteSizeValue)MAX_HISTORY_SIZE_SETTING.get(settings);
    }

    public void put(WatchRecord watchRecord) throws Exception {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            watchRecord.toXContent(builder, (ToXContent.Params)WatcherParams.HIDE_SECRETS);
            IndexRequest request = new IndexRequest(".watcher-history-16").id(watchRecord.id().value()).source(builder);
            request.opType(DocWriteRequest.OpType.CREATE);
            if ((long)request.source().length() > this.maxHistoryRecordSize.getBytes()) {
                WatchRecord redactedWatchRecord = watchRecord.dropLargeFields();
                try (XContentBuilder redactedBuilder = XContentFactory.jsonBuilder();){
                    redactedWatchRecord.toXContent(redactedBuilder, (ToXContent.Params)WatcherParams.HIDE_SECRETS);
                    request.source(redactedBuilder);
                }
            }
            this.bulkProcessor.add(request);
        }
        catch (IOException ioe) {
            throw Exceptions.ioException((String)"failed to persist watch record [{}]", (Throwable)ioe, (Object[])new Object[]{watchRecord});
        }
    }

    public void forcePut(WatchRecord watchRecord) {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            watchRecord.toXContent(builder, (ToXContent.Params)WatcherParams.HIDE_SECRETS);
            IndexRequest request = new IndexRequest(".watcher-history-16").id(watchRecord.id().value()).source(builder);
            request.opType(DocWriteRequest.OpType.CREATE);
            this.bulkProcessor.add(request);
        }
        catch (IOException ioe) {
            WatchRecord wr = watchRecord;
            logger.error(() -> "failed to persist watch record [" + wr + "]", (Throwable)ioe);
        }
    }

    public static boolean validate(ClusterState state) {
        IndexMetadata indexMetadata = WatchStoreUtils.getConcreteIndex(".watcher-history-16", state.metadata());
        return indexMetadata == null || indexMetadata.getState() == IndexMetadata.State.OPEN && state.routingTable().index(indexMetadata.getIndex()).allPrimaryShardsActive();
    }
}

