/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.logging;

import java.util.Locale;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.SuppressLoggerChecks;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum LoggingLevel {
    ERROR{

        @Override
        @SuppressLoggerChecks(reason="logger delegation")
        void log(Logger logger, String text) {
            logger.error(text);
        }
    }
    ,
    WARN{

        @Override
        @SuppressLoggerChecks(reason="logger delegation")
        void log(Logger logger, String text) {
            logger.warn(text);
        }
    }
    ,
    INFO{

        @Override
        @SuppressLoggerChecks(reason="logger delegation")
        void log(Logger logger, String text) {
            logger.info(text);
        }
    }
    ,
    DEBUG{

        @Override
        @SuppressLoggerChecks(reason="logger delegation")
        void log(Logger logger, String text) {
            logger.debug(text);
        }
    }
    ,
    TRACE{

        @Override
        @SuppressLoggerChecks(reason="logger delegation")
        void log(Logger logger, String text) {
            logger.trace(text);
        }
    };


    abstract void log(Logger var1, String var2);

    public String value() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

