/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.util.Objects;

public interface NumberDefinition {
    public static boolean booleanValue(Comparable<?> number) {
        Objects.requireNonNull(number);
        return NumberDefinition.toBoolean(NumberDefinition.intValue(number));
    }

    public static byte byteValue(Comparable<?> number) {
        Objects.requireNonNull(number);
        if (number instanceof NumberDefinition) {
            return ((NumberDefinition)((Object)number)).byteValue();
        }
        if (number instanceof Number) {
            return ((Number)((Object)number)).byteValue();
        }
        return -128;
    }

    public static double doubleValue(Comparable<?> number) {
        Objects.requireNonNull(number);
        if (number instanceof NumberDefinition) {
            return ((NumberDefinition)((Object)number)).doubleValue();
        }
        if (number instanceof Number) {
            return ((Number)((Object)number)).doubleValue();
        }
        return Double.NaN;
    }

    public static float floatValue(Comparable<?> number) {
        Objects.requireNonNull(number);
        if (number instanceof NumberDefinition) {
            return ((NumberDefinition)((Object)number)).floatValue();
        }
        if (number instanceof Number) {
            return ((Number)((Object)number)).floatValue();
        }
        return Float.NaN;
    }

    public static int intValue(Comparable<?> number) {
        Objects.requireNonNull(number);
        if (number instanceof NumberDefinition) {
            return ((NumberDefinition)((Object)number)).intValue();
        }
        if (number instanceof Number) {
            return ((Number)((Object)number)).intValue();
        }
        return Integer.MIN_VALUE;
    }

    public static long longValue(Comparable<?> number) {
        Objects.requireNonNull(number);
        if (number instanceof NumberDefinition) {
            return ((NumberDefinition)((Object)number)).longValue();
        }
        if (number instanceof Number) {
            return ((Number)((Object)number)).longValue();
        }
        return Long.MIN_VALUE;
    }

    public static short shortValue(Comparable<?> number) {
        Objects.requireNonNull(number);
        if (number instanceof NumberDefinition) {
            return ((NumberDefinition)((Object)number)).shortValue();
        }
        if (number instanceof Number) {
            return ((Number)((Object)number)).shortValue();
        }
        return Short.MIN_VALUE;
    }

    public static boolean toBoolean(int value) {
        return value != 0;
    }

    public static int toInt(double value) {
        return Math.round((float)value);
    }

    public static int toInt(float value) {
        return Math.round(value);
    }

    public static long toLong(double value) {
        return Math.round(value);
    }

    default public boolean booleanValue() {
        return NumberDefinition.toBoolean(this.intValue());
    }

    default public byte byteValue() {
        return (byte)this.intValue();
    }

    public double doubleValue();

    default public float floatValue() {
        return (float)this.doubleValue();
    }

    default public int intValue() {
        return NumberDefinition.toInt(this.floatValue());
    }

    default public long longValue() {
        return NumberDefinition.toLong(this.doubleValue());
    }

    default public short shortValue() {
        return (short)this.intValue();
    }
}

