/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.ojalgo.array.ArrayAnyD;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.Primitive32Array;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.StructureAnyD;

public abstract class IDX {
    public static ArrayAnyD<Double> parse(File filePath) {
        return IDX.parse(filePath, Primitive32Array.FACTORY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArrayAnyD<Double> parse(File filePath, DenseArray.Factory<Double> arrayFactory) {
        try (DataInputStream input = new DataInputStream(new BufferedInputStream(new FileInputStream(filePath)));){
            input.read();
            input.read();
            int type = input.read();
            int rank = input.read();
            long[] structure = new long[rank];
            for (int i = 0; i < rank; ++i) {
                structure[rank - 1 - i] = input.readInt();
            }
            StructureAnyD data = ArrayAnyD.factory(arrayFactory).make(structure);
            long limit = ((ArrayAnyD)data).count();
            block20: for (long i = 0L; i < limit; ++i) {
                switch (type) {
                    case 8: {
                        ((ArrayAnyD)data).set(i, (float)input.readUnsignedByte());
                        continue block20;
                    }
                    case 9: {
                        ((ArrayAnyD)data).set(i, (float)input.readByte());
                        continue block20;
                    }
                    case 11: {
                        ((ArrayAnyD)data).set(i, (float)input.readShort());
                        continue block20;
                    }
                    case 200: {
                        ((ArrayAnyD)data).set(i, (float)input.readInt());
                        continue block20;
                    }
                    case 13: {
                        ((ArrayAnyD)data).set(i, input.readFloat());
                        continue block20;
                    }
                    case 14: {
                        ((ArrayAnyD)data).set(i, input.readDouble());
                        continue block20;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown element type!");
                    }
                }
            }
            StructureAnyD structureAnyD = data;
            return structureAnyD;
        }
        catch (IOException cause) {
            throw new RuntimeException(cause);
        }
    }

    public static ArrayAnyD<Double> parse(String filePath) {
        return IDX.parse(new File(filePath));
    }

    public static ArrayAnyD<Double> parse(String filePath, DenseArray.Factory<Double> arrayFactory) {
        return IDX.parse(new File(filePath), arrayFactory);
    }

    public static void print(Access2D<?> image, BasicLogger.Printer printer) {
        IDX.print(image, printer, true);
    }

    public static void print(Access2D<?> image, BasicLogger.Printer printer, boolean transpose) {
        double maxValue = 0.0;
        int i = 0;
        while ((long)i < image.count()) {
            maxValue = Math.max(maxValue, image.doubleValue(i));
            ++i;
        }
        IDX.print(image, printer, transpose, maxValue);
    }

    public static void print(Access2D<?> image, BasicLogger.Printer printer, boolean transpose, double maxExpectedValue) {
        double oneThird = maxExpectedValue / 3.0;
        double twoThirds = 2.0 * maxExpectedValue / 3.0;
        long numbRows = image.countRows();
        long numbCols = image.countColumns();
        if (transpose) {
            for (long j = 0L; j < numbCols; ++j) {
                for (long i = 0L; i < numbRows; ++i) {
                    IDX.printPixel(image.doubleValue(i, j), printer, oneThird, twoThirds);
                }
                printer.println();
            }
        } else {
            for (long i = 0L; i < numbRows; ++i) {
                for (long j = 0L; j < numbCols; ++j) {
                    IDX.printPixel(image.doubleValue(i, j), printer, oneThird, twoThirds);
                }
                printer.println();
            }
        }
    }

    private static void printPixel(double gray, BasicLogger.Printer printer, double oneThird, double twoThirds) {
        if (gray < oneThird) {
            printer.print(" ");
        } else if (gray < twoThirds) {
            printer.print("+");
        } else {
            printer.print("X");
        }
    }
}

