/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.RandomAccess;
import org.ojalgo.array.DenseArray;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.structure.Access1D;

public abstract class PlainArray<N extends Comparable<N>>
extends DenseArray<N>
implements RandomAccess {
    static final int CHARACTERISTICS = 1040;

    PlainArray(DenseArray.Factory<N> factory, int size) {
        super(factory);
        if (size > 0x7FFFFFF7) {
            throw new IllegalArgumentException("Array too large!");
        }
    }

    @Override
    public final void add(long index, Comparable<?> addend) {
        this.add(Math.toIntExact(index), addend);
    }

    @Override
    public final void add(long index, double addend) {
        this.add(Math.toIntExact(index), addend);
    }

    @Override
    public final void add(long index, float addend) {
        this.add(Math.toIntExact(index), addend);
    }

    @Override
    public final long count() {
        return this.size();
    }

    @Override
    public final double doubleValue(long index) {
        return this.doubleValue((int)index);
    }

    @Override
    public final void fillAll(N number) {
        this.fill(0, this.size(), 1, number);
    }

    @Override
    public final void fillAll(NullaryFunction<?> supplier) {
        this.fill(0, this.size(), 1, supplier);
    }

    @Override
    public final void fillOne(long index, Access1D<?> values, long valueIndex) {
        this.fillOne(Math.toIntExact(index), values, valueIndex);
    }

    @Override
    public final void fillOne(long index, N value) {
        this.fillOne(Math.toIntExact(index), value);
    }

    @Override
    public final void fillOne(long index, NullaryFunction<?> supplier) {
        this.fillOne(Math.toIntExact(index), supplier);
    }

    @Override
    public final void fillRange(long first, long limit, N number) {
        this.fill(first, limit, 1L, number);
    }

    @Override
    public final void fillRange(long first, long limit, NullaryFunction<?> supplier) {
        this.fill(first, limit, 1L, supplier);
    }

    @Override
    public final float floatValue(long index) {
        return this.floatValue((int)index);
    }

    @Override
    public final N get(long index) {
        return this.get((int)index);
    }

    @Override
    public final void modifyOne(long index, UnaryFunction<N> modifier) {
        this.modifyOne(Math.toIntExact(index), modifier);
    }

    @Override
    public final void set(long index, Comparable<?> number) {
        this.set((int)index, number);
    }

    @Override
    public final void set(long index, double value) {
        this.set((int)index, value);
    }

    @Override
    public final void set(long index, float value) {
        this.set((int)index, value);
    }

    @Override
    public final void visitOne(long index, VoidFunction<N> visitor) {
        this.visitOne(Math.toIntExact(index), visitor);
    }

    private final boolean isSmall(int first, int limit, int step, double comparedTo) {
        boolean retVal = true;
        for (int i = first; retVal && i < limit; retVal &= this.isSmall(i, comparedTo), i += step) {
        }
        return retVal;
    }

    protected abstract void add(int var1, Comparable<?> var2);

    protected abstract void add(int var1, double var2);

    protected abstract void add(int var1, float var2);

    protected abstract double doubleValue(int var1);

    protected abstract void exchange(int var1, int var2, int var3, int var4);

    @Override
    protected final void exchange(long firstA, long firstB, long step, long count) {
        this.exchange(Math.toIntExact(firstA), Math.toIntExact(firstB), Math.toIntExact(step), Math.toIntExact(count));
    }

    protected abstract void fill(int var1, int var2, Access1D<N> var3, BinaryFunction<N> var4, Access1D<N> var5);

    protected abstract void fill(int var1, int var2, Access1D<N> var3, BinaryFunction<N> var4, N var5);

    protected abstract void fill(int var1, int var2, int var3, N var4);

    protected abstract void fill(int var1, int var2, int var3, NullaryFunction<?> var4);

    protected abstract void fill(int var1, int var2, N var3, BinaryFunction<N> var4, Access1D<N> var5);

    @Override
    protected final void fill(long first, long limit, long step, N value) {
        this.fill(Math.toIntExact(first), Math.toIntExact(limit), Math.toIntExact(step), value);
    }

    @Override
    protected final void fill(long first, long limit, long step, NullaryFunction<?> supplier) {
        this.fill(Math.toIntExact(first), Math.toIntExact(limit), Math.toIntExact(step), supplier);
    }

    protected abstract void fillOne(int var1, Access1D<?> var2, long var3);

    protected abstract void fillOne(int var1, N var2);

    protected abstract void fillOne(int var1, NullaryFunction<?> var2);

    protected abstract float floatValue(int var1);

    protected abstract N get(int var1);

    protected abstract int indexOfLargest(int var1, int var2, int var3);

    @Override
    protected final long indexOfLargest(long first, long limit, long step) {
        return this.indexOfLargest(Math.toIntExact(first), Math.toIntExact(limit), Math.toIntExact(step));
    }

    protected abstract boolean isAbsolute(int var1);

    protected abstract boolean isSmall(int var1, double var2);

    protected abstract void modify(int var1, int var2, int var3, Access1D<N> var4, BinaryFunction<N> var5);

    protected abstract void modify(int var1, int var2, int var3, BinaryFunction<N> var4, Access1D<N> var5);

    protected abstract void modify(int var1, int var2, int var3, BinaryFunction<N> var4, N var5);

    protected abstract void modify(int var1, int var2, int var3, N var4, BinaryFunction<N> var5);

    protected abstract void modify(int var1, int var2, int var3, ParameterFunction<N> var4, int var5);

    protected abstract void modify(int var1, int var2, int var3, UnaryFunction<N> var4);

    @Override
    protected final void modify(long first, long limit, long step, Access1D<N> left, BinaryFunction<N> function) {
        this.modify(Math.toIntExact(first), Math.toIntExact(limit), Math.toIntExact(step), (N)left, function);
    }

    @Override
    protected final void modify(long first, long limit, long step, BinaryFunction<N> function, Access1D<N> right) {
        this.modify(Math.toIntExact(first), Math.toIntExact(limit), Math.toIntExact(step), function, (N)right);
    }

    @Override
    protected final void modify(long first, long limit, long step, UnaryFunction<N> function) {
        this.modify(Math.toIntExact(first), Math.toIntExact(limit), Math.toIntExact(step), function);
    }

    protected abstract void modifyOne(int var1, UnaryFunction<N> var2);

    protected abstract int searchAscending(N var1);

    protected abstract void set(int var1, Comparable<?> var2);

    protected abstract void set(int var1, double var2);

    protected abstract void set(int var1, float var2);

    protected abstract void sortAscending();

    protected abstract void sortDescending();

    protected abstract void visit(int var1, int var2, int var3, VoidFunction<N> var4);

    @Override
    protected final void visit(long first, long limit, long step, VoidFunction<N> visitor) {
        this.visit(Math.toIntExact(first), Math.toIntExact(limit), Math.toIntExact(step), visitor);
    }

    protected abstract void visitOne(int var1, VoidFunction<N> var2);
}

