/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;

public class TypedChainTaskExecutor<T> {
    private final Executor executorService;
    private final LinkedList<ChainTask<T>> tasks = new LinkedList();
    private final Predicate<Exception> failureShortCircuitPredicate;
    private final Predicate<T> continuationPredicate;
    private final List<T> collectedResponses;

    public TypedChainTaskExecutor(Executor executorService, Predicate<T> continuationPredicate, Predicate<Exception> failureShortCircuitPredicate) {
        this.executorService = Objects.requireNonNull(executorService);
        this.continuationPredicate = continuationPredicate;
        this.failureShortCircuitPredicate = failureShortCircuitPredicate;
        this.collectedResponses = new ArrayList<T>();
    }

    public synchronized void add(ChainTask<T> task) {
        this.tasks.add(task);
    }

    private synchronized void execute(T previousValue, final ActionListener<List<T>> listener) {
        this.collectedResponses.add(previousValue);
        if (this.continuationPredicate.test(previousValue)) {
            if (this.tasks.isEmpty()) {
                listener.onResponse(Collections.unmodifiableList(new ArrayList<T>(this.collectedResponses)));
                return;
            }
            final ChainTask<T> task = this.tasks.pop();
            this.executorService.execute((Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    if (TypedChainTaskExecutor.this.failureShortCircuitPredicate.test(e)) {
                        listener.onFailure(e);
                    } else {
                        TypedChainTaskExecutor.this.execute(null, listener);
                    }
                }

                protected void doRun() {
                    task.run(ActionListener.wrap(value -> TypedChainTaskExecutor.this.execute(value, listener), this::onFailure));
                }
            });
        } else {
            listener.onResponse(Collections.unmodifiableList(new ArrayList<T>(this.collectedResponses)));
        }
    }

    public synchronized void execute(final ActionListener<List<T>> listener) {
        if (this.tasks.isEmpty()) {
            listener.onResponse(Collections.emptyList());
            return;
        }
        this.collectedResponses.clear();
        final ChainTask<T> task = this.tasks.pop();
        this.executorService.execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                if (TypedChainTaskExecutor.this.failureShortCircuitPredicate.test(e)) {
                    listener.onFailure(e);
                } else {
                    TypedChainTaskExecutor.this.execute(null, listener);
                }
            }

            protected void doRun() {
                task.run(ActionListener.wrap(value -> TypedChainTaskExecutor.this.execute(value, listener), this::onFailure));
            }
        });
    }

    public synchronized List<T> getCollectedResponses() {
        return List.copyOf(this.collectedResponses);
    }

    public static interface ChainTask<T> {
        public void run(ActionListener<T> var1);
    }
}

