/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.core.ml.job.config.DataDescription;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.ml.job.categorization.CategorizationAnalyzer;
import org.elasticsearch.xpack.ml.job.process.DataCountsReporter;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.AbstractDataToProcessWriter;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.XContentRecordReader;

public class JsonDataToProcessWriter
extends AbstractDataToProcessWriter {
    private static final Logger LOGGER = LogManager.getLogger(JsonDataToProcessWriter.class);
    private final XContentParserConfiguration parserConfig;

    public JsonDataToProcessWriter(boolean includeControlField, boolean includeTokensField, AutodetectProcess autodetectProcess, DataDescription dataDescription, AnalysisConfig analysisConfig, DataCountsReporter dataCountsReporter, NamedXContentRegistry xContentRegistry) {
        super(includeControlField, includeTokensField, autodetectProcess, dataDescription, analysisConfig, dataCountsReporter, LOGGER);
        this.parserConfig = XContentParserConfiguration.EMPTY.withRegistry(xContentRegistry).withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
    }

    @Override
    public void write(InputStream inputStream, CategorizationAnalyzer categorizationAnalyzer, XContentType xContentType, BiConsumer<DataCounts, Exception> handler) throws IOException {
        this.dataCountsReporter.startNewIncrementalCount();
        if (xContentType.canonical() == XContentType.JSON) {
            this.writeJsonXContent(categorizationAnalyzer, inputStream);
        } else if (xContentType.canonical() == XContentType.SMILE) {
            this.writeSmileXContent(categorizationAnalyzer, inputStream);
        } else {
            throw new RuntimeException("XContentType [" + xContentType + "] is not supported by JsonDataToProcessWriter");
        }
        this.dataCountsReporter.finishReporting();
        handler.accept(this.dataCountsReporter.incrementalStats(), null);
    }

    private void writeJsonXContent(CategorizationAnalyzer categorizationAnalyzer, InputStream inputStream) throws IOException {
        try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(this.parserConfig, inputStream);){
            this.writeJson(categorizationAnalyzer, parser);
        }
    }

    private void writeSmileXContent(CategorizationAnalyzer categorizationAnalyzer, InputStream inputStream) throws IOException {
        byte[] nextObject;
        while ((nextObject = JsonDataToProcessWriter.findNextObject(XContentType.SMILE.xContent().bulkSeparator(), inputStream)).length != 0) {
            XContentParser parser = XContentFactory.xContent((XContentType)XContentType.SMILE).createParser(this.parserConfig, nextObject);
            try {
                this.writeJson(categorizationAnalyzer, parser);
            }
            finally {
                if (parser == null) continue;
                parser.close();
            }
        }
    }

    private static byte[] findNextObject(byte marker, InputStream data) throws IOException {
        int nextByte;
        assert (data.markSupported());
        data.mark(-1);
        int counter = 0;
        do {
            nextByte = data.read();
            ++counter;
            if (nextByte != (marker & 0xFF)) continue;
            data.reset();
            byte[] buffer = new byte[counter];
            data.read(buffer);
            return buffer;
        } while (nextByte != -1);
        return new byte[0];
    }

    private void writeJson(CategorizationAnalyzer categorizationAnalyzer, XContentParser parser) throws IOException {
        Collection<String> inputFields = this.inputFields();
        this.buildFieldIndexMapping(inputFields.toArray(new String[0]));
        int numFields = this.outputFieldCount();
        String[] input = new String[numFields];
        Object[] record = new String[numFields];
        boolean[] gotFields = new boolean[inputFields.size()];
        XContentRecordReader recordReader = new XContentRecordReader(parser, this.inFieldIndexes, LOGGER);
        Integer categorizationFieldIndex = (Integer)this.inFieldIndexes.get(this.analysisConfig.getCategorizationFieldName());
        long inputFieldCount = recordReader.read(input, gotFields);
        while (inputFieldCount >= 0L) {
            Arrays.fill(record, "");
            inputFieldCount = Math.max(inputFieldCount - 1L, 0L);
            long missing = JsonDataToProcessWriter.missingFieldCount(gotFields);
            if (missing > 0L) {
                this.dataCountsReporter.reportMissingFields(missing);
            }
            for (AbstractDataToProcessWriter.InputOutputMap inOut : this.inputOutputMap) {
                String field = input[inOut.inputIndex];
                String string = field = field == null ? "" : field;
                if (categorizationFieldIndex != null && inOut.inputIndex == categorizationFieldIndex) {
                    field = this.maybeTruncateCatgeorizationField(field);
                }
                record[inOut.outputIndex] = field;
            }
            if (categorizationAnalyzer != null && categorizationFieldIndex != null) {
                this.tokenizeForCategorization(categorizationAnalyzer, input[categorizationFieldIndex], (String[])record);
            }
            this.transformTimeAndWrite((String[])record, inputFieldCount);
            inputFieldCount = recordReader.read(input, gotFields);
        }
    }

    @Override
    protected boolean checkForMissingFields(Collection<String> inputFields, Map<String, Integer> inputFieldIndexes, String[] header) {
        return true;
    }

    private static long missingFieldCount(boolean[] gotFieldFlags) {
        long count = 0L;
        for (boolean gotFieldFlag : gotFieldFlags) {
            if (gotFieldFlag) continue;
            ++count;
        }
        return count;
    }
}

