/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.concurrent.Executor;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelVocabularyAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.ml.inference.nlp.Vocabulary;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;

public class TransportPutTrainedModelVocabularyAction
extends TransportMasterNodeAction<PutTrainedModelVocabularyAction.Request, AcknowledgedResponse> {
    private final TrainedModelProvider trainedModelProvider;
    private final XPackLicenseState licenseState;

    @Inject
    public TransportPutTrainedModelVocabularyAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, XPackLicenseState licenseState, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TrainedModelProvider trainedModelProvider) {
        super("cluster:admin/xpack/ml/trained_models/vocabulary/put", transportService, clusterService, threadPool, actionFilters, PutTrainedModelVocabularyAction.Request::new, indexNameExpressionResolver, AcknowledgedResponse::readFrom, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.licenseState = licenseState;
        this.trainedModelProvider = trainedModelProvider;
    }

    protected void masterOperation(Task task, PutTrainedModelVocabularyAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        ActionListener configActionListener = ActionListener.wrap(config -> {
            InferenceConfig inferenceConfig = config.getInferenceConfig();
            if (inferenceConfig instanceof NlpConfig) {
                NlpConfig nlpConfig = (NlpConfig)inferenceConfig;
                nlpConfig.getTokenization().validateVocabulary(request);
                this.trainedModelProvider.storeTrainedModelVocabulary(request.getModelId(), ((NlpConfig)inferenceConfig).getVocabularyConfig(), new Vocabulary(request.getVocabulary(), request.getModelId(), request.getMerges(), request.getScores()), (ActionListener<Void>)ActionListener.wrap(stored -> listener.onResponse((Object)AcknowledgedResponse.TRUE), arg_0 -> ((ActionListener)listener).onFailure(arg_0)), request.isOverwritingAllowed());
                return;
            }
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("cannot put vocabulary for model [{}] as it is not an NLP model", RestStatus.BAD_REQUEST, new Object[]{request.getModelId()})));
        }, arg_0 -> listener.onFailure(arg_0));
        this.trainedModelProvider.getTrainedModel(request.getModelId(), GetTrainedModelsAction.Includes.empty(), null, (ActionListener<TrainedModelConfig>)configActionListener);
    }

    protected ClusterBlockException checkBlock(PutTrainedModelVocabularyAction.Request request, ClusterState state) {
        return null;
    }

    protected void doExecute(Task task, PutTrainedModelVocabularyAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        if (MachineLearningField.ML_API_FEATURE.check(this.licenseState)) {
            super.doExecute(task, (MasterNodeRequest)request, listener);
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
        }
    }
}

