/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.core.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.ml.datafeed.DatafeedManager;
import org.elasticsearch.xpack.ml.job.JobManager;

public class TransportPutJobAction
extends TransportMasterNodeAction<PutJobAction.Request, PutJobAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportPutJobAction.class);
    private final JobManager jobManager;
    private final DatafeedManager datafeedManager;
    private final XPackLicenseState licenseState;
    private final AnalysisRegistry analysisRegistry;
    private final SecurityContext securityContext;

    @Inject
    public TransportPutJobAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, XPackLicenseState licenseState, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobManager jobManager, DatafeedManager datafeedManager, AnalysisRegistry analysisRegistry) {
        super("cluster:admin/xpack/ml/job/put", transportService, clusterService, threadPool, actionFilters, PutJobAction.Request::new, indexNameExpressionResolver, PutJobAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.licenseState = licenseState;
        this.jobManager = jobManager;
        this.analysisRegistry = analysisRegistry;
        this.datafeedManager = datafeedManager;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
    }

    protected void masterOperation(Task task, PutJobAction.Request request, ClusterState state, ActionListener<PutJobAction.Response> listener) throws Exception {
        this.jobManager.putJob(request, this.analysisRegistry, state, (ActionListener<PutJobAction.Response>)ActionListener.wrap(jobCreated -> {
            if (!jobCreated.getResponse().getDatafeedConfig().isPresent()) {
                listener.onResponse(jobCreated);
                return;
            }
            this.datafeedManager.putDatafeed(new PutDatafeedAction.Request((DatafeedConfig)jobCreated.getResponse().getDatafeedConfig().get()), this.clusterService.state(), this.securityContext, this.threadPool, (ActionListener<PutDatafeedAction.Response>)ActionListener.wrap(createdDatafeed -> {
                if (createdDatafeed.getResponse().getHeaders().isEmpty()) {
                    listener.onResponse(jobCreated);
                } else {
                    Job.Builder finalJobBuilder = new Job.Builder(jobCreated.getResponse()).setDatafeed(new DatafeedConfig.Builder(createdDatafeed.getResponse()));
                    listener.onResponse((Object)new PutJobAction.Response(finalJobBuilder.build()));
                }
            }, failed -> this.jobManager.deleteJob(new DeleteJobAction.Request(request.getJobBuilder().getId()), state, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(deleted -> listener.onFailure(failed), deleteFailed -> {
                logger.warn(() -> Strings.format((String)"[%s] failed to cleanup job after datafeed creation failure", (Object[])new Object[]{request.getJobBuilder().getId()}), (Throwable)deleteFailed);
                ElasticsearchStatusException ex = new ElasticsearchStatusException("failed to cleanup job after datafeed creation failure", RestStatus.REQUEST_TIMEOUT, (Throwable)failed, new Object[0]);
                ex.addSuppressed((Throwable)deleteFailed);
                listener.onFailure((Exception)((Object)ex));
            }))));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(PutJobAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void doExecute(Task task, PutJobAction.Request request, ActionListener<PutJobAction.Response> listener) {
        if (MachineLearningField.ML_API_FEATURE.check(this.licenseState)) {
            super.doExecute(task, (MasterNodeRequest)request, listener);
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
        }
    }
}

