/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.ClearDeploymentCacheAction;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingInfo;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignment;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignmentMetadata;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.inference.deployment.TrainedModelDeploymentTask;

public class TransportClearDeploymentCacheAction
extends TransportTasksAction<TrainedModelDeploymentTask, ClearDeploymentCacheAction.Request, ClearDeploymentCacheAction.Response, ClearDeploymentCacheAction.Response> {
    @Inject
    public TransportClearDeploymentCacheAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService) {
        super("cluster:admin/xpack/ml/trained_models/deployment/clear_cache", clusterService, transportService, actionFilters, ClearDeploymentCacheAction.Request::new, ClearDeploymentCacheAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    protected ClearDeploymentCacheAction.Response newResponse(ClearDeploymentCacheAction.Request request, List<ClearDeploymentCacheAction.Response> taskResponse, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (!taskOperationFailures.isEmpty()) {
            throw ExceptionsHelper.taskOperationFailureToStatusException((TaskOperationFailure)taskOperationFailures.get(0));
        }
        if (!failedNodeExceptions.isEmpty()) {
            throw failedNodeExceptions.get(0);
        }
        return new ClearDeploymentCacheAction.Response(true);
    }

    protected void doExecute(Task task, ClearDeploymentCacheAction.Request request, ActionListener<ClearDeploymentCacheAction.Response> listener) {
        ClusterState clusterState = this.clusterService.state();
        TrainedModelAssignmentMetadata assignment = TrainedModelAssignmentMetadata.fromState((ClusterState)clusterState);
        TrainedModelAssignment trainedModelAssignment = assignment.getDeploymentAssignment(request.getDeploymentId());
        if (trainedModelAssignment == null) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.missingModelDeployment((String)request.getDeploymentId())));
            return;
        }
        String[] nodes = (String[])trainedModelAssignment.getNodeRoutingTable().entrySet().stream().filter(entry -> ((RoutingInfo)entry.getValue()).isRoutable()).map(Map.Entry::getKey).toArray(String[]::new);
        if (nodes.length == 0) {
            listener.onResponse((Object)new ClearDeploymentCacheAction.Response(true));
            return;
        }
        request.setNodes(nodes);
        super.doExecute(task, (BaseTasksRequest)request, listener);
    }

    protected void taskOperation(CancellableTask actionTask, ClearDeploymentCacheAction.Request request, TrainedModelDeploymentTask task, ActionListener<ClearDeploymentCacheAction.Response> listener) {
        task.clearCache((ActionListener<AcknowledgedResponse>)listener.delegateFailureAndWrap((l, r) -> l.onResponse((Object)new ClearDeploymentCacheAction.Response(true))));
    }
}

