/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ilm.OperationMode;
import org.elasticsearch.xpack.core.ilm.OperationModeUpdateTask;
import org.elasticsearch.xpack.core.slm.action.StopSLMAction;

public class TransportStopSLMAction
extends AcknowledgedTransportMasterNodeAction<StopSLMAction.Request> {
    @Inject
    public TransportStopSLMAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/slm/stop", transportService, clusterService, threadPool, actionFilters, StopSLMAction.Request::new, indexNameExpressionResolver, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    protected void masterOperation(Task task, StopSLMAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.submitUnbatchedTask("slm_operation_mode_update[stopping]", (ClusterStateUpdateTask)OperationModeUpdateTask.wrap((OperationModeUpdateTask)OperationModeUpdateTask.slmMode((OperationMode)OperationMode.STOPPING), (AcknowledgedRequest)request, listener));
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    protected ClusterBlockException checkBlock(StopSLMAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

