/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.extras;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOFunction;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.elasticsearch.common.CheckedIntFunction;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.SourceValueFetcherSortedBinaryIndexFieldData;
import org.elasticsearch.index.fielddata.StoredFieldSortedBinaryIndexFieldData;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.index.mapper.BlockStoredFieldsReader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.StringStoredFieldFieldLoader;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.TextParams;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.extras.SourceConfirmedTextQuery;
import org.elasticsearch.index.mapper.extras.SourceIntervalsSource;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.field.TextDocValuesField;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.xcontent.XContentBuilder;

public class MatchOnlyTextFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "match_only_text";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.indexVersionCreated(), c.getIndexAnalyzers()));
    private final IndexVersion indexCreatedVersion;
    private final IndexAnalyzers indexAnalyzers;
    private final NamedAnalyzer indexAnalyzer;
    private final int positionIncrementGap;
    private final boolean storeSource;
    private final FieldType fieldType;

    private MatchOnlyTextFieldMapper(String simpleName, FieldType fieldType, MatchOnlyTextFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, boolean storeSource, Builder builder) {
        super(simpleName, (MappedFieldType)mappedFieldType, multiFields, copyTo, false, null);
        assert (mappedFieldType.getTextSearchInfo().isTokenized());
        assert (!mappedFieldType.hasDocValues());
        this.fieldType = MatchOnlyTextFieldMapper.freezeAndDeduplicateFieldType((FieldType)fieldType);
        this.indexCreatedVersion = builder.indexCreatedVersion;
        this.indexAnalyzers = builder.analyzers.indexAnalyzers;
        this.indexAnalyzer = builder.analyzers.getIndexAnalyzer();
        this.positionIncrementGap = (Integer)builder.analyzers.positionIncrementGap.getValue();
        this.storeSource = storeSource;
    }

    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), this.indexAnalyzer);
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.indexCreatedVersion, this.indexAnalyzers).init(this);
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        String value = context.parser().textOrNull();
        if (value == null) {
            return;
        }
        Field field = new Field(this.fieldType().name(), (CharSequence)value, (IndexableFieldType)this.fieldType);
        context.doc().add((IndexableField)field);
        context.addToFieldNames(this.fieldType().name());
        if (this.storeSource) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().storedFieldNameForSyntheticSource(), value));
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public MatchOnlyTextFieldType fieldType() {
        return (MatchOnlyTextFieldType)super.fieldType();
    }

    protected FieldMapper.SyntheticSourceMode syntheticSourceMode() {
        return FieldMapper.SyntheticSourceMode.NATIVE;
    }

    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        if (!this.copyTo.copyToFields().isEmpty()) {
            throw new IllegalArgumentException("field [" + this.fullPath() + "] of type [" + this.typeName() + "] doesn't support synthetic source because it declares copy_to");
        }
        return new StringStoredFieldFieldLoader(this.fieldType().storedFieldNameForSyntheticSource(), this.leafName(), null){

            protected void write(XContentBuilder b, Object value) throws IOException {
                b.value((String)value);
            }
        };
    }

    public static class MatchOnlyTextFieldType
    extends StringFieldType {
        private final Analyzer indexAnalyzer;
        private final TextFieldMapper.TextFieldType textFieldType;

        public MatchOnlyTextFieldType(String name, TextSearchInfo tsi, Analyzer indexAnalyzer, boolean isSyntheticSource, Map<String, String> meta) {
            super(name, true, false, false, tsi, meta);
            this.indexAnalyzer = Objects.requireNonNull(indexAnalyzer);
            this.textFieldType = new TextFieldMapper.TextFieldType(name, isSyntheticSource);
        }

        public MatchOnlyTextFieldType(String name) {
            this(name, new TextSearchInfo(Defaults.FIELD_TYPE, null, Lucene.STANDARD_ANALYZER, Lucene.STANDARD_ANALYZER), (Analyzer)Lucene.STANDARD_ANALYZER, false, Collections.emptyMap());
        }

        public String typeName() {
            return MatchOnlyTextFieldMapper.CONTENT_TYPE;
        }

        public String familyTypeName() {
            return "text";
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.toString((String)this.name(), (SearchExecutionContext)context, (String)format);
        }

        private IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> getValueFetcherProvider(SearchExecutionContext searchExecutionContext) {
            if (!searchExecutionContext.isSourceEnabled()) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [match_only_text] cannot run positional queries since [_source] is disabled.");
            }
            if (searchExecutionContext.isSourceSynthetic()) {
                String name = this.storedFieldNameForSyntheticSource();
                StoredFieldLoader loader = StoredFieldLoader.create((boolean)false, Set.of(name));
                return context -> {
                    LeafStoredFieldLoader leafLoader = loader.getLoader(context, null);
                    return docId -> {
                        leafLoader.advanceTo(docId);
                        return (List)leafLoader.storedFields().get(name);
                    };
                };
            }
            return context -> {
                ValueFetcher valueFetcher = this.valueFetcher(searchExecutionContext, null);
                SearchLookup sourceProvider = searchExecutionContext.lookup();
                valueFetcher.setNextReader(context);
                return arg_0 -> MatchOnlyTextFieldType.lambda$getValueFetcherProvider$2(valueFetcher, (SourceProvider)sourceProvider, context, arg_0);
            };
        }

        private Query toQuery(Query query, SearchExecutionContext searchExecutionContext) {
            return new ConstantScoreQuery((Query)new SourceConfirmedTextQuery(query, this.getValueFetcherProvider(searchExecutionContext), this.indexAnalyzer));
        }

        private IntervalsSource toIntervalsSource(IntervalsSource source, Query approximation, SearchExecutionContext searchExecutionContext) {
            return new SourceIntervalsSource(source, approximation, this.getValueFetcherProvider(searchExecutionContext), this.indexAnalyzer);
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            return new ConstantScoreQuery(super.termQuery(value, context));
        }

        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context, MultiTermQuery.RewriteMethod rewriteMethod) {
            return new ConstantScoreQuery(super.fuzzyQuery(value, fuzziness, prefixLength, maxExpansions, transpositions, context, rewriteMethod));
        }

        public IntervalsSource termIntervals(BytesRef term, SearchExecutionContext context) {
            return this.toIntervalsSource(Intervals.term((BytesRef)term), (Query)new TermQuery(new Term(this.name(), term)), context);
        }

        public IntervalsSource prefixIntervals(BytesRef term, SearchExecutionContext context) {
            return this.toIntervalsSource(Intervals.prefix((BytesRef)term), (Query)new PrefixQuery(new Term(this.name(), term)), context);
        }

        public IntervalsSource fuzzyIntervals(String term, int maxDistance, int prefixLength, boolean transpositions, SearchExecutionContext context) {
            FuzzyQuery fuzzyQuery = new FuzzyQuery(new Term(this.name(), term), maxDistance, prefixLength, 128, transpositions, MultiTermQuery.CONSTANT_SCORE_BLENDED_REWRITE);
            IntervalsSource fuzzyIntervals = Intervals.multiterm((CompiledAutomaton)fuzzyQuery.getAutomata(), (String)term);
            return this.toIntervalsSource(fuzzyIntervals, (Query)fuzzyQuery, context);
        }

        public IntervalsSource wildcardIntervals(BytesRef pattern, SearchExecutionContext context) {
            return this.toIntervalsSource(Intervals.wildcard((BytesRef)pattern), (Query)new MatchAllDocsQuery(), context);
        }

        public Query phraseQuery(TokenStream stream, int slop, boolean enablePosIncrements, SearchExecutionContext queryShardContext) throws IOException {
            Query query = this.textFieldType.phraseQuery(stream, slop, enablePosIncrements, queryShardContext);
            return this.toQuery(query, queryShardContext);
        }

        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, SearchExecutionContext queryShardContext) throws IOException {
            Query query = this.textFieldType.multiPhraseQuery(stream, slop, enablePositionIncrements, queryShardContext);
            return this.toQuery(query, queryShardContext);
        }

        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions, SearchExecutionContext queryShardContext) throws IOException {
            Query query = this.textFieldType.phrasePrefixQuery(stream, slop, maxExpansions, queryShardContext);
            return this.toQuery(query, queryShardContext);
        }

        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (this.textFieldType.isSyntheticSource()) {
                return new BlockStoredFieldsReader.BytesFromStringsBlockLoader(this.storedFieldNameForSyntheticSource());
            }
            SourceValueFetcher fetcher = SourceValueFetcher.toString((Set)blContext.sourcePaths(this.name()));
            BlockSourceReader.LeafIteratorLookup lookup = BlockSourceReader.lookupFromFieldNames((FieldNamesFieldMapper.FieldNamesFieldType)blContext.fieldNames(), (String)this.name());
            return new BlockSourceReader.BytesRefsBlockLoader((ValueFetcher)fetcher, lookup);
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            if (fieldDataContext.fielddataOperation() != MappedFieldType.FielddataOperation.SCRIPT) {
                throw new IllegalArgumentException("match_only_text fields do not support sorting and aggregations");
            }
            if (this.textFieldType.isSyntheticSource()) {
                return (cache, breaker) -> new StoredFieldSortedBinaryIndexFieldData(this.storedFieldNameForSyntheticSource(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, TextDocValuesField::new){

                    protected BytesRef storedToBytesRef(Object stored) {
                        return new BytesRef((CharSequence)((String)stored));
                    }
                };
            }
            return new SourceValueFetcherSortedBinaryIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, (ValueFetcher)SourceValueFetcher.toString((Set)((Set)fieldDataContext.sourcePathsLookup().apply(this.name()))), (SourceProvider)fieldDataContext.lookupSupplier().get(), TextDocValuesField::new);
        }

        private String storedFieldNameForSyntheticSource() {
            return this.name() + "._original";
        }

        private static /* synthetic */ List lambda$getValueFetcherProvider$2(ValueFetcher valueFetcher, SourceProvider sourceProvider, LeafReaderContext context, int docID) throws IOException {
            try {
                return valueFetcher.fetchValues(sourceProvider.getSource(context, docID), docID, new ArrayList());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final IndexVersion indexCreatedVersion;
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final TextParams.Analyzers analyzers;

        public Builder(String name, IndexAnalyzers indexAnalyzers) {
            this(name, IndexVersion.current(), indexAnalyzers);
        }

        public Builder(String name, IndexVersion indexCreatedVersion, IndexAnalyzers indexAnalyzers) {
            super(name);
            this.indexCreatedVersion = indexCreatedVersion;
            this.analyzers = new TextParams.Analyzers(indexAnalyzers, m -> ((MatchOnlyTextFieldMapper)m).indexAnalyzer, m -> ((MatchOnlyTextFieldMapper)m).positionIncrementGap, indexCreatedVersion);
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.meta};
        }

        private MatchOnlyTextFieldType buildFieldType(MapperBuilderContext context) {
            NamedAnalyzer searchAnalyzer = this.analyzers.getSearchAnalyzer();
            NamedAnalyzer searchQuoteAnalyzer = this.analyzers.getSearchQuoteAnalyzer();
            NamedAnalyzer indexAnalyzer = this.analyzers.getIndexAnalyzer();
            TextSearchInfo tsi = new TextSearchInfo(Defaults.FIELD_TYPE, null, searchAnalyzer, searchQuoteAnalyzer);
            MatchOnlyTextFieldType ft = new MatchOnlyTextFieldType(context.buildFullName(this.leafName()), tsi, (Analyzer)indexAnalyzer, context.isSourceSynthetic(), (Map)this.meta.getValue());
            return ft;
        }

        public MatchOnlyTextFieldMapper build(MapperBuilderContext context) {
            MatchOnlyTextFieldType tft = this.buildFieldType(context);
            FieldMapper.MultiFields multiFields = this.multiFieldsBuilder.build((Mapper.Builder)this, context);
            return new MatchOnlyTextFieldMapper(this.leafName(), Defaults.FIELD_TYPE, tft, multiFields, this.copyTo, context.isSourceSynthetic(), this);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE;

        static {
            FieldType ft = new FieldType();
            ft.setTokenized(true);
            ft.setStored(false);
            ft.setStoreTermVectors(false);
            ft.setOmitNorms(true);
            ft.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE = Mapper.freezeAndDeduplicateFieldType((FieldType)ft);
        }
    }
}

