/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.util;

import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.ql.InvalidArgumentException;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public final class StringUtils {
    public static final String EMPTY = "";
    public static final String NEW_LINE = "\n";
    public static final String SQL_WILDCARD = "%";
    public static final String WILDCARD = "*";
    private static final String[] INTEGER_ORDINALS = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
    private static final String INVALID_REGEX_SEQUENCE = "Invalid sequence - escape character is not followed by special wildcard char";

    private StringUtils() {
    }

    public static String camelCaseToUnderscore(String string) {
        if (!Strings.hasText((String)string)) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        String s = string.trim();
        boolean previousCharWasUp = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (Character.isAlphabetic(ch)) {
                if (Character.isUpperCase(ch)) {
                    if (i > 0 && i < s.length() - 1 && !previousCharWasUp) {
                        sb.append("_");
                    }
                    previousCharWasUp = true;
                } else {
                    previousCharWasUp = ch == '_';
                }
            } else {
                previousCharWasUp = true;
            }
            sb.append(ch);
        }
        return sb.toString().toUpperCase(Locale.ROOT);
    }

    public static String underscoreToLowerCamelCase(String string) {
        if (!Strings.hasText((String)string)) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        String s = string.trim().toLowerCase(Locale.ROOT);
        boolean previousCharWasUnderscore = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '_') {
                previousCharWasUnderscore = true;
                continue;
            }
            if (previousCharWasUnderscore) {
                sb.append(Character.toUpperCase(ch));
                previousCharWasUnderscore = false;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String likeToJavaPattern(String pattern, char escape) {
        StringBuilder regex = new StringBuilder(pattern.length() + 4);
        boolean escaped = false;
        regex.append('^');
        for (int i = 0; i < pattern.length(); ++i) {
            char curr = pattern.charAt(i);
            if (!escaped && curr == escape && escape != '\u0000') {
                escaped = true;
                if (i + 1 != pattern.length()) continue;
                throw new InvalidArgumentException(INVALID_REGEX_SEQUENCE, new Object[0]);
            }
            switch (curr) {
                case '%': {
                    regex.append(escaped ? SQL_WILDCARD : ".*");
                    break;
                }
                case '_': {
                    regex.append(escaped ? "_" : ".");
                    break;
                }
                default: {
                    if (escaped) {
                        throw new InvalidArgumentException(INVALID_REGEX_SEQUENCE, new Object[0]);
                    }
                    switch (curr) {
                        case '$': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case '.': 
                        case '?': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '^': 
                        case '{': 
                        case '|': 
                        case '}': {
                            regex.append('\\');
                        }
                    }
                    regex.append(curr);
                }
            }
            escaped = false;
        }
        regex.append('$');
        return regex.toString();
    }

    public static String wildcardToJavaPattern(String pattern, char escape) {
        StringBuilder regex = new StringBuilder(pattern.length() + 4);
        boolean escaped = false;
        regex.append('^');
        for (int i = 0; i < pattern.length(); ++i) {
            char curr = pattern.charAt(i);
            if (!escaped && curr == escape && escape != '\u0000') {
                escaped = true;
                if (i + 1 != pattern.length()) continue;
                throw new InvalidArgumentException(INVALID_REGEX_SEQUENCE, new Object[0]);
            }
            switch (curr) {
                case '*': {
                    regex.append(escaped ? "\\*" : ".*");
                    break;
                }
                case '?': {
                    regex.append(escaped ? "\\?" : ".");
                    break;
                }
                default: {
                    if (escaped && escape != curr) {
                        throw new InvalidArgumentException(INVALID_REGEX_SEQUENCE, new Object[0]);
                    }
                    switch (curr) {
                        case '$': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case '.': 
                        case '?': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '^': 
                        case '{': 
                        case '|': 
                        case '}': {
                            regex.append('\\');
                        }
                    }
                    regex.append(curr);
                }
            }
            escaped = false;
        }
        regex.append('$');
        return regex.toString();
    }

    public static String likeToLuceneWildcard(String pattern, char escape) {
        StringBuilder wildcard = new StringBuilder(pattern.length() + 4);
        boolean escaped = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char curr = pattern.charAt(i);
            if (!escaped && curr == escape && escape != '\u0000') {
                if (i + 1 == pattern.length()) {
                    throw new InvalidArgumentException(INVALID_REGEX_SEQUENCE, new Object[0]);
                }
                escaped = true;
                continue;
            }
            switch (curr) {
                case '%': {
                    wildcard.append(escaped ? SQL_WILDCARD : WILDCARD);
                    break;
                }
                case '_': {
                    wildcard.append(escaped ? "_" : "?");
                    break;
                }
                default: {
                    if (escaped) {
                        throw new InvalidArgumentException(INVALID_REGEX_SEQUENCE, new Object[0]);
                    }
                    switch (curr) {
                        case '*': 
                        case '?': 
                        case '\\': {
                            wildcard.append('\\');
                        }
                    }
                    wildcard.append(curr);
                }
            }
            escaped = false;
        }
        return wildcard.toString();
    }

    public static String likeToIndexWildcard(String pattern, char escape) {
        StringBuilder wildcard = new StringBuilder(pattern.length() + 4);
        boolean escaped = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char curr = pattern.charAt(i);
            if (!escaped && curr == escape && escape != '\u0000') {
                if (i + 1 == pattern.length()) {
                    throw new InvalidArgumentException(INVALID_REGEX_SEQUENCE, new Object[0]);
                }
                escaped = true;
                continue;
            }
            switch (curr) {
                case '%': {
                    wildcard.append(escaped ? SQL_WILDCARD : WILDCARD);
                    break;
                }
                case '_': {
                    wildcard.append(escaped ? "_" : WILDCARD);
                    break;
                }
                default: {
                    if (escaped) {
                        throw new InvalidArgumentException(INVALID_REGEX_SEQUENCE, new Object[0]);
                    }
                    wildcard.append(curr);
                }
            }
            escaped = false;
        }
        return wildcard.toString();
    }

    public static String likeToUnescaped(String pattern, char escape) {
        StringBuilder wildcard = new StringBuilder(pattern.length());
        boolean escaped = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char curr = pattern.charAt(i);
            if (!escaped && curr == escape && escape != '\u0000') {
                escaped = true;
                continue;
            }
            if (escaped && (curr == '%' || curr == '_' || curr == escape)) {
                wildcard.append(curr);
            } else {
                if (escaped) {
                    wildcard.append(escape);
                }
                wildcard.append(curr);
            }
            escaped = false;
        }
        if (escaped) {
            wildcard.append(escape);
        }
        return wildcard.toString();
    }

    public static String toString(SearchSourceBuilder source) {
        String string;
        block8: {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint().humanReadable(true);
            try {
                source.toXContent(builder, ToXContent.EMPTY_PARAMS);
                string = Strings.toString((XContentBuilder)builder);
                if (builder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("error rendering", e);
                }
            }
            builder.close();
        }
        return string;
    }

    public static List<String> findSimilar(String match, Iterable<String> potentialMatches) {
        LevenshteinDistance ld = new LevenshteinDistance();
        ArrayList<Tuple> scoredMatches = new ArrayList<Tuple>();
        for (String potentialMatch : potentialMatches) {
            float distance = ld.getDistance(match, potentialMatch);
            if (!(distance >= 0.5f)) continue;
            scoredMatches.add(new Tuple((Object)Float.valueOf(distance), (Object)potentialMatch));
        }
        CollectionUtil.timSort(scoredMatches, (a, b) -> ((Float)b.v1()).compareTo((Float)a.v1()));
        return scoredMatches.stream().map(a -> (String)a.v2()).collect(Collectors.toList());
    }

    public static double parseDouble(String string) throws InvalidArgumentException {
        double value;
        try {
            value = Double.parseDouble(string);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidArgumentException(nfe, "Cannot parse number [{}]", string);
        }
        if (Double.isInfinite(value)) {
            throw new InvalidArgumentException("Number [{}] is too large", string);
        }
        if (Double.isNaN(value)) {
            throw new InvalidArgumentException("[{}] cannot be parsed as a number (NaN)", string);
        }
        return value;
    }

    public static long parseLong(String string) throws InvalidArgumentException {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException nfe) {
            try {
                BigInteger bi = new BigInteger(string);
                try {
                    bi.longValueExact();
                }
                catch (ArithmeticException ae) {
                    throw new InvalidArgumentException("Number [{}] is too large", string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            throw new InvalidArgumentException("Cannot parse number [{}]", string);
        }
    }

    public static Number parseIntegral(String string) throws InvalidArgumentException {
        BigInteger bi;
        try {
            bi = new BigInteger(string);
        }
        catch (NumberFormatException ex) {
            throw new InvalidArgumentException(ex, "Cannot parse number [{}]", string);
        }
        if (bi.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            if (!NumericUtils.isUnsignedLong(bi)) {
                throw new InvalidArgumentException("Number [{}] is too large", string);
            }
            return bi;
        }
        if ((long)bi.intValue() == bi.longValue()) {
            return bi.intValueExact();
        }
        return bi.longValueExact();
    }

    public static BytesRef parseIP(String string) {
        InetAddress inetAddress = InetAddresses.forString((String)string);
        return new BytesRef(InetAddressPoint.encode((InetAddress)inetAddress));
    }

    public static String ordinal(int i) {
        return switch (i % 100) {
            case 11, 12, 13 -> i + "th";
            default -> i + INTEGER_ORDINALS[i % 10];
        };
    }

    public static Tuple<String, String> splitQualifiedIndex(String indexName) {
        int separatorOffset = indexName.indexOf(58);
        return separatorOffset > 0 ? Tuple.tuple((Object)indexName.substring(0, separatorOffset), (Object)indexName.substring(separatorOffset + 1)) : Tuple.tuple(null, (Object)indexName);
    }

    public static String qualifyAndJoinIndices(String cluster, String[] indices) {
        StringJoiner sj = new StringJoiner(",");
        for (String index : indices) {
            sj.add(cluster != null ? RemoteClusterAware.buildRemoteIndexName((String)cluster, (String)index) : index);
        }
        return sj.toString();
    }

    public static boolean isQualified(String indexWildcard) {
        return indexWildcard.indexOf(58) > 0;
    }
}

