/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.analyzer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.ql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.ql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.rule.ParameterizedRule;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.EsField;
import org.elasticsearch.xpack.ql.type.InvalidMappedField;
import org.elasticsearch.xpack.ql.type.UnsupportedEsField;

public final class AnalyzerRules {
    public static Function resolveFunction(UnresolvedFunction uf, Configuration configuration, FunctionRegistry functionRegistry) {
        Function f = null;
        if (uf.analyzed()) {
            f = uf;
        } else if (!uf.childrenResolved()) {
            f = uf;
        } else {
            String functionName = functionRegistry.resolveAlias(uf.name());
            if (!functionRegistry.functionExists(functionName)) {
                f = uf.missing(functionName, functionRegistry.listFunctions());
            } else {
                FunctionDefinition def = functionRegistry.resolveFunction(functionName);
                f = uf.buildResolved(configuration, def);
            }
        }
        return f;
    }

    public static List<Attribute> maybeResolveAgainstList(UnresolvedAttribute u, Collection<Attribute> attrList, java.util.function.Function<Attribute, Attribute> fieldInspector) {
        String qualifier = u.qualifier();
        String name = u.name();
        boolean qualified = u.qualifier() != null;
        Predicate<Attribute> predicate = a -> qualified ? Objects.equals(qualifier, a.qualifiedName()) : Objects.equals(name, a.name()) || Objects.equals(name, a.qualifiedName());
        return AnalyzerRules.maybeResolveAgainstList(predicate, () -> u, attrList, false, fieldInspector);
    }

    public static List<Attribute> maybeResolveAgainstList(Predicate<Attribute> matcher, Supplier<UnresolvedAttribute> unresolved, Collection<Attribute> attrList, boolean isPattern, java.util.function.Function<Attribute, Attribute> fieldInspector) {
        ArrayList<Attribute> matches = new ArrayList<Attribute>();
        for (Attribute attribute : attrList) {
            boolean match;
            if (attribute.synthetic() || !(match = matcher.test(attribute))) continue;
            matches.add(attribute);
        }
        if (matches.isEmpty()) {
            return matches;
        }
        UnresolvedAttribute ua = unresolved.get();
        if (matches.size() == 1 || isPattern) {
            matches.replaceAll(e -> (Attribute)fieldInspector.apply((Attribute)e));
            return matches;
        }
        List<String> refs = matches.stream().sorted((a, b) -> {
            int lineDiff = a.sourceLocation().getLineNumber() - b.sourceLocation().getLineNumber();
            int colDiff = a.sourceLocation().getColumnNumber() - b.sourceLocation().getColumnNumber();
            return lineDiff != 0 ? lineDiff : (colDiff != 0 ? colDiff : a.qualifiedName().compareTo(b.qualifiedName()));
        }).map(a -> "line " + a.sourceLocation().toString().substring(1) + " [" + (String)(a.qualifier() != null ? "\"" + a.qualifier() + "\".\"" + a.name() + "\"" : a.name()) + "]").toList();
        return Collections.singletonList(ua.withUnresolvedMessage("Reference [" + ua.qualifiedName() + "] is ambiguous (to disambiguate use quotes or qualifiers); matches any of " + refs));
    }

    public static Attribute handleSpecialFields(UnresolvedAttribute u, Attribute named, boolean allowCompound) {
        if (named instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)named;
            EsField esField = fa.field();
            if (esField instanceof InvalidMappedField) {
                InvalidMappedField imf = (InvalidMappedField)esField;
                named = u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] due to ambiguities being " + imf.errorMessage());
            } else if (DataTypes.isUnsupported(fa.dataType())) {
                UnsupportedEsField unsupportedField = (UnsupportedEsField)fa.field();
                named = unsupportedField.hasInherited() ? u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] with unsupported type [" + unsupportedField.getOriginalType() + "] in hierarchy (field [" + unsupportedField.getInherited() + "])") : u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] with unsupported type [" + unsupportedField.getOriginalType() + "]");
            } else if (!allowCompound && !DataTypes.isPrimitive(fa.dataType())) {
                named = u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] type [" + fa.dataType().typeName() + "] only its subfields");
            }
        }
        return named.withLocation(u.source());
    }

    public static abstract class BaseAnalyzerRule
    extends AnalyzerRule<LogicalPlan> {
        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            if (!plan.childrenResolved()) {
                return plan;
            }
            return this.doRule(plan);
        }

        protected abstract LogicalPlan doRule(LogicalPlan var1);
    }

    public static abstract class ParameterizedAnalyzerRule<SubPlan extends LogicalPlan, P>
    extends ParameterizedRule<SubPlan, LogicalPlan, P> {
        @Override
        public final LogicalPlan apply(LogicalPlan plan, P context) {
            return plan.transformUp(this.typeToken(), t -> t.analyzed() || this.skipResolved() && t.resolved() ? t : this.rule(t, context));
        }

        protected abstract LogicalPlan rule(SubPlan var1, P var2);

        protected boolean skipResolved() {
            return true;
        }
    }

    public static abstract class AnalyzerRule<SubPlan extends LogicalPlan>
    extends Rule<SubPlan, LogicalPlan> {
        @Override
        public final LogicalPlan apply(LogicalPlan plan) {
            return plan.transformUp(this.typeToken(), t -> t.analyzed() || this.skipResolved() && t.resolved() ? t : this.rule(t));
        }

        protected abstract LogicalPlan rule(SubPlan var1);

        protected boolean skipResolved() {
            return true;
        }
    }

    public static class AddMissingEqualsToBoolField
    extends AnalyzerRule<Filter> {
        @Override
        protected LogicalPlan rule(Filter filter) {
            if (!filter.resolved()) {
                return filter;
            }
            Expression condition = AddMissingEqualsToBoolField.replaceRawBoolFieldWithEquals(filter.condition());
            if (condition == filter.condition()) {
                condition = condition.transformUp(BinaryLogic.class, b -> b.replaceChildren((List)Arrays.asList(AddMissingEqualsToBoolField.replaceRawBoolFieldWithEquals(b.left()), AddMissingEqualsToBoolField.replaceRawBoolFieldWithEquals(b.right()))));
            }
            if (condition != filter.condition()) {
                filter = filter.with(condition);
            }
            return filter;
        }

        private static Expression replaceRawBoolFieldWithEquals(Expression e) {
            if (e instanceof FieldAttribute && e.dataType() == DataTypes.BOOLEAN) {
                e = new Equals(e.source(), e, Literal.of(e, Boolean.TRUE));
            }
            return e;
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }
    }
}

