/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm;

import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.scheduler.SchedulerEngine;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ilm.LifecycleOperationMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicySecurityClient;
import org.elasticsearch.xpack.core.slm.SnapshotInvocationRecord;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleStats;
import org.elasticsearch.xpack.slm.SnapshotLifecycleService;
import org.elasticsearch.xpack.slm.history.SnapshotHistoryItem;
import org.elasticsearch.xpack.slm.history.SnapshotHistoryStore;

public class SnapshotLifecycleTask
implements SchedulerEngine.Listener {
    private static final Logger logger = LogManager.getLogger(SnapshotLifecycleTask.class);
    private final Client client;
    private final ClusterService clusterService;
    private final SnapshotHistoryStore historyStore;

    public SnapshotLifecycleTask(Client client, ClusterService clusterService, SnapshotHistoryStore historyStore) {
        this.client = client;
        this.clusterService = clusterService;
        this.historyStore = historyStore;
    }

    public void triggered(SchedulerEngine.Event event) {
        logger.debug("snapshot lifecycle policy task triggered from job [{}]", (Object)event.getJobName());
        Optional<String> snapshotName = SnapshotLifecycleTask.maybeTakeSnapshot(event.getJobName(), this.client, this.clusterService, this.historyStore);
        snapshotName.ifPresent(name -> logger.info("snapshot lifecycle policy job [{}] issued new snapshot creation for [{}] successfully", (Object)event.getJobName(), name));
        if (!snapshotName.isPresent()) {
            logger.warn("snapshot lifecycle policy for job [{}] no longer exists, snapshot not created", (Object)event.getJobName());
        }
    }

    public static Optional<String> maybeTakeSnapshot(String jobId, Client client, final ClusterService clusterService, final SnapshotHistoryStore historyStore) {
        Optional<SnapshotLifecyclePolicyMetadata> maybeMetadata = SnapshotLifecycleTask.getSnapPolicyMetadata(jobId, clusterService.state());
        String snapshotName = maybeMetadata.map(policyMetadata -> {
            final CreateSnapshotRequest request = policyMetadata.getPolicy().toRequest(TimeValue.MAX_VALUE);
            LifecyclePolicySecurityClient clientWithHeaders = new LifecyclePolicySecurityClient(client, "index_lifecycle", policyMetadata.getHeaders());
            logger.info("snapshot lifecycle policy [{}] issuing create snapshot [{}]", (Object)policyMetadata.getPolicy().getId(), (Object)request.snapshot());
            clientWithHeaders.admin().cluster().createSnapshot(request, (ActionListener)new ActionListener<CreateSnapshotResponse>(){

                public void onResponse(CreateSnapshotResponse createSnapshotResponse) {
                    logger.debug("snapshot response for [{}]: {}", (Object)policyMetadata.getPolicy().getId(), (Object)org.elasticsearch.common.Strings.toString((ToXContent)createSnapshotResponse));
                    SnapshotInfo snapInfo = createSnapshotResponse.getSnapshotInfo();
                    if (snapInfo.failedShards() == 0) {
                        long snapshotStartTime = snapInfo.startTime();
                        long timestamp = Instant.now().toEpochMilli();
                        SnapshotLifecycleTask.submitUnbatchedTask(clusterService, "slm-record-success-" + policyMetadata.getPolicy().getId(), WriteJobStatus.success(policyMetadata.getPolicy().getId(), request.snapshot(), snapshotStartTime, timestamp));
                        historyStore.putAsync(SnapshotHistoryItem.creationSuccessRecord(timestamp, policyMetadata.getPolicy(), request.snapshot()));
                    } else {
                        int failures = snapInfo.failedShards();
                        int total = snapInfo.totalShards();
                        SnapshotException e = new SnapshotException(request.repository(), request.snapshot(), "failed to create snapshot successfully, " + failures + " out of " + total + " total shards failed");
                        this.onFailure((Exception)e);
                    }
                }

                public void onFailure(Exception e) {
                    logger.error("failed to create snapshot for snapshot lifecycle policy [{}]: {}", (Object)policyMetadata.getPolicy().getId(), (Object)e);
                    long timestamp = Instant.now().toEpochMilli();
                    SnapshotLifecycleTask.submitUnbatchedTask(clusterService, "slm-record-failure-" + policyMetadata.getPolicy().getId(), WriteJobStatus.failure(policyMetadata.getPolicy().getId(), request.snapshot(), timestamp, e));
                    try {
                        SnapshotHistoryItem failureRecord = SnapshotHistoryItem.creationFailureRecord(timestamp, policyMetadata.getPolicy(), request.snapshot(), e);
                        historyStore.putAsync(failureRecord);
                    }
                    catch (IOException ex) {
                        logger.error(() -> Strings.format((String)"failed to record snapshot creation failure for snapshot lifecycle policy [%s]", (Object[])new Object[]{policyMetadata.getPolicy().getId()}), (Throwable)e);
                    }
                }
            });
            return request.snapshot();
        }).orElse(null);
        return Optional.ofNullable(snapshotName);
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private static void submitUnbatchedTask(ClusterService clusterService, String source, ClusterStateUpdateTask task) {
        clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    static Optional<SnapshotLifecyclePolicyMetadata> getSnapPolicyMetadata(String jobId, ClusterState state) {
        return Optional.ofNullable((SnapshotLifecycleMetadata)state.metadata().custom("snapshot_lifecycle")).map(SnapshotLifecycleMetadata::getSnapshotConfigurations).flatMap(configMap -> configMap.values().stream().filter(policyMeta -> jobId.equals(SnapshotLifecycleService.getJobId(policyMeta))).findFirst());
    }

    public static String exceptionToString(Exception ex) {
        return org.elasticsearch.common.Strings.toString((builder, params) -> {
            ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)params, (Throwable)ex);
            return builder;
        }, (ToXContent.Params)ToXContent.EMPTY_PARAMS);
    }

    private static class WriteJobStatus
    extends ClusterStateUpdateTask {
        private final String policyName;
        private final String snapshotName;
        private final long snapshotStartTime;
        private final long snapshotFinishTime;
        private final Optional<Exception> exception;

        private WriteJobStatus(String policyName, String snapshotName, long snapshotStartTime, long snapshotFinishTime, Optional<Exception> exception) {
            this.policyName = policyName;
            this.snapshotName = snapshotName;
            this.exception = exception;
            this.snapshotStartTime = snapshotStartTime;
            this.snapshotFinishTime = snapshotFinishTime;
        }

        static WriteJobStatus success(String policyId, String snapshotName, long snapshotStartTime, long snapshotFinishTime) {
            return new WriteJobStatus(policyId, snapshotName, snapshotStartTime, snapshotFinishTime, Optional.empty());
        }

        static WriteJobStatus failure(String policyId, String snapshotName, long timestamp, Exception exception) {
            return new WriteJobStatus(policyId, snapshotName, timestamp, timestamp, Optional.of(exception));
        }

        public ClusterState execute(ClusterState currentState) throws Exception {
            SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)currentState.metadata().custom("snapshot_lifecycle");
            assert (snapMeta != null) : "this should never be called while the snapshot lifecycle cluster metadata is null";
            if (snapMeta == null) {
                logger.error("failed to record snapshot [{}] for snapshot [{}] in policy [{}]: snapshot lifecycle metadata is null", (Object)(this.exception.isPresent() ? "failure" : "success"), (Object)this.snapshotName, (Object)this.policyName);
                return currentState;
            }
            HashMap<String, SnapshotLifecyclePolicyMetadata> snapLifecycles = new HashMap<String, SnapshotLifecyclePolicyMetadata>(snapMeta.getSnapshotConfigurations());
            SnapshotLifecyclePolicyMetadata policyMetadata = (SnapshotLifecyclePolicyMetadata)snapLifecycles.get(this.policyName);
            if (policyMetadata == null) {
                logger.warn("failed to record snapshot [{}] for snapshot [{}] in policy [{}]: policy not found", (Object)(this.exception.isPresent() ? "failure" : "success"), (Object)this.snapshotName, (Object)this.policyName);
                return currentState;
            }
            SnapshotLifecyclePolicyMetadata.Builder newPolicyMetadata = SnapshotLifecyclePolicyMetadata.builder((SnapshotLifecyclePolicyMetadata)policyMetadata);
            SnapshotLifecycleStats stats = snapMeta.getStats();
            if (this.exception.isPresent()) {
                stats.snapshotFailed(this.policyName);
                newPolicyMetadata.setLastFailure(new SnapshotInvocationRecord(this.snapshotName, null, this.snapshotFinishTime, (String)this.exception.map(SnapshotLifecycleTask::exceptionToString).orElse(null)));
                newPolicyMetadata.setInvocationsSinceLastSuccess(policyMetadata.getInvocationsSinceLastSuccess() + 1L);
            } else {
                stats.snapshotTaken(this.policyName);
                newPolicyMetadata.setLastSuccess(new SnapshotInvocationRecord(this.snapshotName, Long.valueOf(this.snapshotStartTime), this.snapshotFinishTime, null));
                newPolicyMetadata.setInvocationsSinceLastSuccess(0L);
            }
            snapLifecycles.put(this.policyName, newPolicyMetadata.build());
            SnapshotLifecycleMetadata lifecycleMetadata = new SnapshotLifecycleMetadata(snapLifecycles, LifecycleOperationMetadata.currentSLMMode((ClusterState)currentState), stats);
            Metadata currentMeta = currentState.metadata();
            return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentMeta).putCustom("snapshot_lifecycle", (Metadata.Custom)lifecycleMetadata)).build();
        }

        public void onFailure(Exception e) {
            logger.error("failed to record snapshot policy execution status [{}] for snapshot [{}] in policy [{}]: {}", (Object)(this.exception.isPresent() ? "failure" : "success"), (Object)this.snapshotName, (Object)this.policyName, (Object)e);
        }
    }
}

