/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.Index;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.action.ShardFollowNodeTask;
import org.elasticsearch.xpack.core.ccr.action.FollowStatsAction;
import org.elasticsearch.xpack.core.ccr.action.ShardFollowTask;

public class TransportFollowStatsAction
extends TransportTasksAction<ShardFollowNodeTask, FollowStatsAction.StatsRequest, FollowStatsAction.StatsResponses, FollowStatsAction.StatsResponse> {
    private final CcrLicenseChecker ccrLicenseChecker;

    @Inject
    public TransportFollowStatsAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, CcrLicenseChecker ccrLicenseChecker) {
        super("cluster:monitor/ccr/follow_stats", clusterService, transportService, actionFilters, FollowStatsAction.StatsRequest::new, FollowStatsAction.StatsResponse::new, (Executor)transportService.getThreadPool().executor("ccr"));
        this.ccrLicenseChecker = Objects.requireNonNull(ccrLicenseChecker);
    }

    protected void doExecute(Task task, FollowStatsAction.StatsRequest request, ActionListener<FollowStatsAction.StatsResponses> listener) {
        ClusterState state;
        Set<String> shardFollowTaskFollowerIndices;
        if (!this.ccrLicenseChecker.isCcrAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ccr"));
            return;
        }
        if (!Strings.isAllOrWildcard((String[])request.indices()) && (shardFollowTaskFollowerIndices = TransportFollowStatsAction.findFollowerIndicesFromShardFollowTasks(state = this.clusterService.state(), request.indices())).isEmpty()) {
            String resources = String.join((CharSequence)",", request.indices());
            throw new ResourceNotFoundException("No shard follow tasks for follower indices [{}]", new Object[]{resources});
        }
        super.doExecute(task, (BaseTasksRequest)request, listener);
    }

    protected FollowStatsAction.StatsResponses newResponse(FollowStatsAction.StatsRequest request, List<FollowStatsAction.StatsResponse> statsRespons, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return new FollowStatsAction.StatsResponses(taskOperationFailures, failedNodeExceptions, statsRespons);
    }

    protected List<ShardFollowNodeTask> processTasks(FollowStatsAction.StatsRequest request) {
        ClusterState state = this.clusterService.state();
        Set<String> followerIndices = TransportFollowStatsAction.findFollowerIndicesFromShardFollowTasks(state, request.indices());
        ArrayList<ShardFollowNodeTask> tasks = new ArrayList<ShardFollowNodeTask>();
        for (Task task : this.taskManager.getTasks().values()) {
            ShardFollowNodeTask shardFollowNodeTask;
            if (!(task instanceof ShardFollowNodeTask) || !followerIndices.contains((shardFollowNodeTask = (ShardFollowNodeTask)task).getFollowShardId().getIndexName())) continue;
            tasks.add(shardFollowNodeTask);
        }
        return tasks;
    }

    protected void taskOperation(CancellableTask actionTask, FollowStatsAction.StatsRequest request, ShardFollowNodeTask task, ActionListener<FollowStatsAction.StatsResponse> listener) {
        listener.onResponse((Object)new FollowStatsAction.StatsResponse(task.getStatus()));
    }

    static Set<String> findFollowerIndicesFromShardFollowTasks(ClusterState state, String[] indices) {
        PersistentTasksCustomMetadata persistentTasksMetadata = (PersistentTasksCustomMetadata)state.metadata().custom("persistent_tasks");
        if (persistentTasksMetadata == null) {
            return Collections.emptySet();
        }
        Metadata metadata = state.metadata();
        HashSet<String> requestedFollowerIndices = indices != null ? new HashSet<String>(Arrays.asList(indices)) : Collections.emptySet();
        return persistentTasksMetadata.tasks().stream().filter(persistentTask -> persistentTask.getTaskName().equals("xpack/ccr/shard_follow_task")).map(persistentTask -> {
            ShardFollowTask shardFollowTask = (ShardFollowTask)persistentTask.getParams();
            return shardFollowTask.getFollowShardId().getIndex();
        }).filter(followerIndex -> metadata.index(followerIndex) != null).map(Index::getName).filter(followerIndex -> Strings.isAllOrWildcard((String[])indices) || requestedFollowerIndices.contains(followerIndex)).collect(Collectors.toSet());
    }
}

