/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.Objects;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.action.AutoFollowCoordinator;
import org.elasticsearch.xpack.core.ccr.AutoFollowStats;
import org.elasticsearch.xpack.core.ccr.action.CcrStatsAction;
import org.elasticsearch.xpack.core.ccr.action.FollowStatsAction;

public class TransportCcrStatsAction
extends TransportMasterNodeAction<CcrStatsAction.Request, CcrStatsAction.Response> {
    private final Client client;
    private final CcrLicenseChecker ccrLicenseChecker;
    private final AutoFollowCoordinator autoFollowCoordinator;

    @Inject
    public TransportCcrStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AutoFollowCoordinator autoFollowCoordinator, CcrLicenseChecker ccrLicenseChecker, Client client) {
        super("cluster:monitor/ccr/stats", transportService, clusterService, threadPool, actionFilters, CcrStatsAction.Request::new, indexNameExpressionResolver, CcrStatsAction.Response::new, (Executor)threadPool.executor("ccr"));
        this.client = client;
        this.ccrLicenseChecker = Objects.requireNonNull(ccrLicenseChecker);
        this.autoFollowCoordinator = Objects.requireNonNull(autoFollowCoordinator);
    }

    protected void doExecute(Task task, CcrStatsAction.Request request, ActionListener<CcrStatsAction.Response> listener) {
        if (!this.ccrLicenseChecker.isCcrAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ccr"));
            return;
        }
        super.doExecute(task, (MasterNodeRequest)request, listener);
    }

    protected void masterOperation(Task task, CcrStatsAction.Request request, ClusterState state, ActionListener<CcrStatsAction.Response> listener) throws Exception {
        FollowStatsAction.StatsRequest statsRequest = new FollowStatsAction.StatsRequest();
        statsRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
        if (request.getTimeout() != null) {
            statsRequest.setTimeout(request.getTimeout());
        }
        this.client.execute((ActionType)FollowStatsAction.INSTANCE, (ActionRequest)statsRequest, listener.delegateFailureAndWrap((l, statsResponse) -> {
            AutoFollowStats stats = this.autoFollowCoordinator.getStats();
            l.onResponse((Object)new CcrStatsAction.Response(stats, statsResponse));
        }));
    }

    protected ClusterBlockException checkBlock(CcrStatsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

