/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.query;

import java.util.function.Consumer;
import org.apache.lucene.document.XYDocValuesField;
import org.apache.lucene.document.XYPointField;
import org.apache.lucene.geo.XYGeometry;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.geo.LuceneGeometriesUtils;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.ShapeType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xpack.spatial.index.mapper.PointFieldMapper;

public class ShapeQueryPointProcessor {
    public Query shapeQuery(Geometry geometry, String fieldName, ShapeRelation relation, SearchExecutionContext context) {
        boolean hasDocValues = this.validateIsPointFieldType(fieldName, context);
        if (relation != ShapeRelation.INTERSECTS) {
            throw new QueryShardException((QueryRewriteContext)context, relation + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
        }
        Consumer<ShapeType> checker = t -> {
            if (t == ShapeType.POINT || t == ShapeType.MULTIPOINT || t == ShapeType.LINESTRING || t == ShapeType.MULTILINESTRING) {
                throw new QueryShardException((QueryRewriteContext)context, "Field [" + fieldName + "] does not support " + t + " queries", new Object[0]);
            }
        };
        XYGeometry[] luceneGeometries = LuceneGeometriesUtils.toXYGeometry((Geometry)geometry, checker);
        Query query = XYPointField.newGeometryQuery((String)fieldName, (XYGeometry[])luceneGeometries);
        if (hasDocValues) {
            Query queryDocValues = XYDocValuesField.newSlowGeometryQuery((String)fieldName, (XYGeometry[])luceneGeometries);
            query = new IndexOrDocValuesQuery(query, queryDocValues);
        }
        return query;
    }

    private boolean validateIsPointFieldType(String fieldName, SearchExecutionContext context) {
        MappedFieldType fieldType = context.getFieldType(fieldName);
        if (!(fieldType instanceof PointFieldMapper.PointFieldType)) {
            throw new QueryShardException((QueryRewriteContext)context, "Expected point field type for Field [" + fieldName + "] but found " + fieldType.typeName(), new Object[0]);
        }
        return fieldType.hasDocValues();
    }
}

