/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.persistence;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;

public class ProfilingIndexTemplateRegistry
extends IndexTemplateRegistry {
    private static final Logger logger = LogManager.getLogger(ProfilingIndexTemplateRegistry.class);
    public static final int INDEX_TEMPLATE_VERSION = 12;
    public static final int PROFILING_EVENTS_VERSION = 4;
    public static final int PROFILING_EXECUTABLES_VERSION = 1;
    public static final int PROFILING_METRICS_VERSION = 2;
    public static final int PROFILING_HOSTS_VERSION = 2;
    public static final int PROFILING_STACKFRAMES_VERSION = 1;
    public static final int PROFILING_STACKTRACES_VERSION = 1;
    public static final int PROFILING_SYMBOLS_VERSION = 1;
    public static final int PROFILING_RETURNPADS_PRIVATE_VERSION = 1;
    public static final int PROFILING_SQ_EXECUTABLES_VERSION = 1;
    public static final int PROFILING_SQ_LEAFFRAMES_VERSION = 1;
    public static final String PROFILING_TEMPLATE_VERSION_VARIABLE = "xpack.profiling.template.version";
    private volatile boolean templatesEnabled;
    private static final List<LifecyclePolicyConfig> LIFECYCLE_POLICY_CONFIGS = List.of(new LifecyclePolicyConfig("profiling-60-days", "/profiling/ilm-policy/profiling-60-days.json", Map.of("xpack.profiling.template.version", String.valueOf(12))));
    private static final Map<String, ComponentTemplate> COMPONENT_TEMPLATE_CONFIGS;
    private static final Map<String, ComposableIndexTemplate> COMPOSABLE_INDEX_TEMPLATE_CONFIGS;

    public ProfilingIndexTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
    }

    public void setTemplatesEnabled(boolean templatesEnabled) {
        this.templatesEnabled = templatesEnabled;
    }

    public void close() {
        this.clusterService.removeListener((ClusterStateListener)this);
    }

    protected String getOrigin() {
        return "profiling";
    }

    protected boolean requiresMasterNode() {
        return true;
    }

    protected List<LifecyclePolicyConfig> getLifecycleConfigs() {
        return LIFECYCLE_POLICY_CONFIGS;
    }

    protected List<LifecyclePolicy> getLifecyclePolicies() {
        return this.templatesEnabled ? this.lifecyclePolicies : Collections.emptyList();
    }

    private static Map<String, String> indexVersion(String index, int version) {
        return Map.of(String.format(Locale.ROOT, "xpack.profiling.index.%s.version", index), String.valueOf(version));
    }

    protected Map<String, ComponentTemplate> getComponentTemplateConfigs() {
        return this.templatesEnabled ? COMPONENT_TEMPLATE_CONFIGS : Collections.emptyMap();
    }

    protected Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        return this.templatesEnabled ? COMPOSABLE_INDEX_TEMPLATE_CONFIGS : Collections.emptyMap();
    }

    protected boolean isUpgradeRequired(LifecyclePolicy currentPolicy, LifecyclePolicy newPolicy) {
        try {
            return ProfilingIndexTemplateRegistry.getVersion(currentPolicy, "current") < ProfilingIndexTemplateRegistry.getVersion(newPolicy, "new");
        }
        catch (IllegalArgumentException ex) {
            logger.warn("Cannot determine whether lifecycle policy upgrade is required.", (Throwable)ex);
            return false;
        }
    }

    private static int getVersion(LifecyclePolicy policy, String logicalVersion) {
        Map meta = policy.getMetadata();
        try {
            return meta != null ? Integer.parseInt(((Object)meta.getOrDefault("version", Integer.MIN_VALUE)).toString()) : Integer.MIN_VALUE;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid version metadata for %s lifecycle policy [%s]", logicalVersion, policy.getName()), ex);
        }
    }

    public static boolean isAllResourcesCreated(ClusterState state, Settings settings) {
        for (String name : COMPONENT_TEMPLATE_CONFIGS.keySet()) {
            ComponentTemplate componentTemplate = (ComponentTemplate)state.metadata().componentTemplates().get(name);
            if (componentTemplate != null && componentTemplate.version() >= 12L) continue;
            return false;
        }
        for (String name : COMPOSABLE_INDEX_TEMPLATE_CONFIGS.keySet()) {
            ComposableIndexTemplate composableIndexTemplate = (ComposableIndexTemplate)state.metadata().templatesV2().get(name);
            if (composableIndexTemplate != null && composableIndexTemplate.version() >= 12L) continue;
            return false;
        }
        if (!DataStreamLifecycle.isDataStreamsLifecycleOnlyMode((Settings)settings)) {
            IndexLifecycleMetadata ilmMetadata = (IndexLifecycleMetadata)state.metadata().custom("index_lifecycle");
            if (ilmMetadata == null) {
                return false;
            }
            for (LifecyclePolicyConfig lifecyclePolicy : LIFECYCLE_POLICY_CONFIGS) {
                LifecyclePolicy existingPolicy = (LifecyclePolicy)ilmMetadata.getPolicies().get(lifecyclePolicy.getPolicyName());
                if (existingPolicy != null && ProfilingIndexTemplateRegistry.getVersion(existingPolicy, "current") >= 12) continue;
                return false;
            }
        }
        return true;
    }

    static {
        HashMap<String, ComponentTemplate> componentTemplates = new HashMap<String, ComponentTemplate>();
        for (IndexTemplateConfig config : List.of(new IndexTemplateConfig("profiling-events", "/profiling/component-template/profiling-events.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE, ProfilingIndexTemplateRegistry.indexVersion("events", 4)), new IndexTemplateConfig("profiling-executables", "/profiling/component-template/profiling-executables.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE, ProfilingIndexTemplateRegistry.indexVersion("executables", 1)), new IndexTemplateConfig("profiling-ilm", "/profiling/component-template/profiling-ilm.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig("profiling-hot-tier", "/profiling/component-template/profiling-hot-tier.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig("profiling-metrics", "/profiling/component-template/profiling-metrics.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE, ProfilingIndexTemplateRegistry.indexVersion("metrics", 2)), new IndexTemplateConfig("profiling-hosts", "/profiling/component-template/profiling-hosts.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE, ProfilingIndexTemplateRegistry.indexVersion("hosts", 2)), new IndexTemplateConfig("profiling-stackframes", "/profiling/component-template/profiling-stackframes.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE, ProfilingIndexTemplateRegistry.indexVersion("stackframes", 1)), new IndexTemplateConfig("profiling-stacktraces", "/profiling/component-template/profiling-stacktraces.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE, ProfilingIndexTemplateRegistry.indexVersion("stacktraces", 1)), new IndexTemplateConfig("profiling-symbols", "/profiling/component-template/profiling-symbols.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE, ProfilingIndexTemplateRegistry.indexVersion("symbols", 1)))) {
            try {
                XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, config.loadBytes());
                try {
                    componentTemplates.put(config.getTemplateName(), ComponentTemplate.parse((XContentParser)parser));
                }
                finally {
                    if (parser == null) continue;
                    parser.close();
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        COMPONENT_TEMPLATE_CONFIGS = Collections.unmodifiableMap(componentTemplates);
        COMPOSABLE_INDEX_TEMPLATE_CONFIGS = ProfilingIndexTemplateRegistry.parseComposableTemplates((IndexTemplateConfig[])new IndexTemplateConfig[]{new IndexTemplateConfig("profiling-events", "/profiling/index-template/profiling-events.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig("profiling-metrics", "/profiling/index-template/profiling-metrics.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig("profiling-hosts", "/profiling/index-template/profiling-hosts.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig("profiling-executables", "/profiling/index-template/profiling-executables.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig("profiling-stackframes", "/profiling/index-template/profiling-stackframes.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig("profiling-stacktraces", "/profiling/index-template/profiling-stacktraces.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig("profiling-returnpads-private", "/profiling/index-template/profiling-returnpads-private.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE, ProfilingIndexTemplateRegistry.indexVersion("returnpads.private", 1)), new IndexTemplateConfig("profiling-sq-executables", "/profiling/index-template/profiling-sq-executables.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE, ProfilingIndexTemplateRegistry.indexVersion("sq.executables", 1)), new IndexTemplateConfig("profiling-sq-leafframes", "/profiling/index-template/profiling-sq-leafframes.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE, ProfilingIndexTemplateRegistry.indexVersion("sq.leafframes", 1)), new IndexTemplateConfig("profiling-symbols-global", "/profiling/index-template/profiling-symbols-global.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig("profiling-symbols-private", "/profiling/index-template/profiling-symbols-private.json", 12, PROFILING_TEMPLATE_VERSION_VARIABLE)});
    }
}

