/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.persistence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.datastreams.CreateDataStreamAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.profiling.persistence.AbstractProfilingPersistenceManager;
import org.elasticsearch.xpack.profiling.persistence.EventsIndex;
import org.elasticsearch.xpack.profiling.persistence.IndexState;
import org.elasticsearch.xpack.profiling.persistence.IndexStateResolver;
import org.elasticsearch.xpack.profiling.persistence.IndexStatus;
import org.elasticsearch.xpack.profiling.persistence.Migration;
import org.elasticsearch.xpack.profiling.persistence.ProfilingIndexAbstraction;

public class ProfilingDataStreamManager
extends AbstractProfilingPersistenceManager<ProfilingDataStream> {
    public static final List<ProfilingDataStream> PROFILING_DATASTREAMS;

    public ProfilingDataStreamManager(ThreadPool threadPool, Client client, ClusterService clusterService, IndexStateResolver indexStateResolver) {
        super(threadPool, client, clusterService, indexStateResolver);
    }

    @Override
    protected void onIndexState(ClusterState clusterState, IndexState<ProfilingDataStream> indexState, ActionListener<? super ActionResponse> listener) {
        IndexStatus status = indexState.getStatus();
        switch (status) {
            case NEEDS_CREATION: {
                this.createDataStream(indexState.getIndex(), listener);
                break;
            }
            case NEEDS_VERSION_BUMP: {
                this.rolloverDataStream(indexState.getIndex(), listener);
                break;
            }
            case NEEDS_MAPPINGS_UPDATE: {
                this.applyMigrations(indexState, listener);
                break;
            }
            default: {
                this.logger.trace("Skipping status change [{}] for data stream [{}].", (Object)status, (Object)indexState.getIndex());
                listener.onResponse(null);
            }
        }
    }

    @Override
    protected Iterable<ProfilingDataStream> getManagedIndices() {
        return PROFILING_DATASTREAMS;
    }

    private void onDataStreamFailure(ProfilingDataStream dataStream, Exception ex) {
        this.logger.error(() -> Strings.format((String)"error for data stream [%s] for [%s]", (Object[])new Object[]{dataStream, "profiling"}), (Throwable)ex);
    }

    private void rolloverDataStream(final ProfilingDataStream dataStream, final ActionListener<? super ActionResponse> listener) {
        this.logger.debug("rolling over data stream [{}].", (Object)dataStream);
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            RolloverRequest request = new RolloverRequest(dataStream.getName(), null);
            request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"profiling", (Object)request, (ActionListener)new ActionListener<RolloverResponse>(){

                public void onResponse(RolloverResponse response) {
                    if (!response.isAcknowledged()) {
                        ProfilingDataStreamManager.this.logger.error("error rolling over data stream [{}] for [{}], request was not acknowledged", (Object)dataStream, (Object)"profiling");
                    } else if (!response.isShardsAcknowledged()) {
                        ProfilingDataStreamManager.this.logger.warn("rolling over data stream [{}] for [{}], shards were not acknowledged", (Object)dataStream, (Object)"profiling");
                    } else if (!response.isRolledOver()) {
                        ProfilingDataStreamManager.this.logger.warn("could not rollover data stream [{}] for [{}].", (Object)dataStream, (Object)"profiling");
                    } else {
                        ProfilingDataStreamManager.this.logger.debug("rolled over data stream [{}] from [{}] to index [{}] for [{}].", (Object)dataStream, (Object)response.getOldIndex(), (Object)response.getNewIndex(), (Object)"profiling");
                    }
                    listener.onResponse((Object)response);
                }

                public void onFailure(Exception e) {
                    ProfilingDataStreamManager.this.onDataStreamFailure(dataStream, e);
                    listener.onFailure(e);
                }
            }, (req, l) -> this.client.admin().indices().rolloverIndex(req, l));
        });
    }

    private void createDataStream(final ProfilingDataStream dataStream, final ActionListener<? super ActionResponse> listener) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            CreateDataStreamAction.Request request = new CreateDataStreamAction.Request(dataStream.getName());
            request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"profiling", (Object)request, (ActionListener)new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    if (!response.isAcknowledged()) {
                        ProfilingDataStreamManager.this.logger.error("error adding data stream [{}] for [{}], request was not acknowledged", (Object)dataStream, (Object)"profiling");
                    }
                    listener.onResponse((Object)response);
                }

                public void onFailure(Exception e) {
                    ProfilingDataStreamManager.this.onDataStreamFailure(dataStream, e);
                    listener.onFailure(e);
                }
            }, (req, l) -> this.client.execute((ActionType)CreateDataStreamAction.INSTANCE, (ActionRequest)req, l));
        });
    }

    public static boolean isAllResourcesCreated(ClusterState state, IndexStateResolver indexStateResolver) {
        for (ProfilingDataStream profilingDataStream : PROFILING_DATASTREAMS) {
            if (indexStateResolver.getIndexState(state, profilingDataStream).getStatus() == IndexStatus.UP_TO_DATE) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyResourceTooOld(ClusterState state, IndexStateResolver indexStateResolver) {
        for (ProfilingDataStream profilingDataStream : PROFILING_DATASTREAMS) {
            if (indexStateResolver.getIndexState(state, profilingDataStream).getStatus() != IndexStatus.TOO_OLD) continue;
            return true;
        }
        return false;
    }

    static {
        ArrayList<ProfilingDataStream> dataStreams = new ArrayList<ProfilingDataStream>(EventsIndex.indexNames().stream().map(n -> ProfilingDataStream.of(n, 4)).toList());
        dataStreams.add(ProfilingDataStream.of("profiling-metrics", 2));
        dataStreams.add(ProfilingDataStream.of("profiling-hosts", 2));
        PROFILING_DATASTREAMS = Collections.unmodifiableList(dataStreams);
    }

    static class ProfilingDataStream
    implements ProfilingIndexAbstraction {
        private final String name;
        private final int version;
        private final List<Migration> migrations;

        public static ProfilingDataStream of(String name, int version) {
            return ProfilingDataStream.of(name, version, null);
        }

        public static ProfilingDataStream of(String name, int version, Migration.Builder builder) {
            List<Migration> migrations = builder != null ? builder.build(version) : null;
            return new ProfilingDataStream(name, version, migrations);
        }

        private ProfilingDataStream(String name, int version, List<Migration> migrations) {
            this.name = name;
            this.version = version;
            this.migrations = migrations;
        }

        public ProfilingDataStream withVersion(int version) {
            return new ProfilingDataStream(this.name, version, this.migrations);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        @Override
        public List<Migration> getMigrations(int currentIndexTemplateVersion) {
            return this.migrations != null ? this.migrations.stream().filter(m -> m.getTargetIndexTemplateVersion() > currentIndexTemplateVersion).toList() : Collections.emptyList();
        }

        @Override
        public IndexMetadata indexMetadata(ClusterState state) {
            Map dataStreams = state.metadata().dataStreams();
            if (dataStreams == null) {
                return null;
            }
            DataStream ds = (DataStream)dataStreams.get(this.getName());
            if (ds == null) {
                return null;
            }
            Index writeIndex = ds.getWriteIndex();
            if (writeIndex == null) {
                return null;
            }
            return state.metadata().index(writeIndex);
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProfilingDataStream that = (ProfilingDataStream)o;
            return this.version == that.version && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.version);
        }
    }
}

