/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.persistence;

import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.xpack.profiling.persistence.IndexState;
import org.elasticsearch.xpack.profiling.persistence.IndexStatus;
import org.elasticsearch.xpack.profiling.persistence.Migration;
import org.elasticsearch.xpack.profiling.persistence.ProfilingIndexAbstraction;

public class IndexStateResolver {
    private static final Logger logger = LogManager.getLogger(IndexStateResolver.class);
    private volatile boolean checkOutdatedIndices;

    public IndexStateResolver(boolean checkOutdatedIndices) {
        this.checkOutdatedIndices = checkOutdatedIndices;
    }

    public void setCheckOutdatedIndices(boolean checkOutdatedIndices) {
        this.checkOutdatedIndices = checkOutdatedIndices;
    }

    public <T extends ProfilingIndexAbstraction> IndexState<T> getIndexState(ClusterState state, T index) {
        IndexMetadata metadata = index.indexMetadata(state);
        if (metadata == null) {
            return new IndexState<T>(index, null, IndexStatus.NEEDS_CREATION);
        }
        if (metadata.getState() == IndexMetadata.State.CLOSE) {
            logger.warn("Index [{}] is closed. This is likely to prevent Universal Profiling from functioning correctly", (Object)metadata.getIndex());
            return new IndexState<T>(index, metadata.getIndex(), IndexStatus.CLOSED);
        }
        IndexRoutingTable routingTable = state.getRoutingTable().index(metadata.getIndex());
        ClusterHealthStatus indexHealth = new ClusterIndexHealth(metadata, routingTable).getStatus();
        if (indexHealth == ClusterHealthStatus.RED) {
            logger.trace("Index [{}] health status is RED, any pending mapping upgrades will wait until this changes", (Object)metadata.getIndex());
            return new IndexState<T>(index, metadata.getIndex(), IndexStatus.UNHEALTHY);
        }
        if (this.checkOutdatedIndices && metadata.getCreationVersion().before((VersionId)IndexVersions.V_8_9_1)) {
            logger.trace("Index [{}] has been created before version 8.9.1 and must be deleted before proceeding with the upgrade.", (Object)metadata.getIndex());
            return new IndexState<T>(index, metadata.getIndex(), IndexStatus.TOO_OLD);
        }
        MappingMetadata mapping = metadata.mapping();
        if (mapping != null) {
            int currentTemplateVersion;
            int currentIndexVersion;
            Map meta = (Map)mapping.sourceAsMap().get("_meta");
            if (meta == null) {
                logger.debug("Missing _meta field in mapping of index [{}], assuming initial version.", (Object)metadata.getIndex());
                currentIndexVersion = 1;
                currentTemplateVersion = 1;
            } else {
                currentIndexVersion = this.getVersionField(metadata.getIndex(), meta, "index-version");
                currentTemplateVersion = this.getVersionField(metadata.getIndex(), meta, "index-template-version");
                if (currentIndexVersion == -1 || currentTemplateVersion == -1) {
                    return new IndexState<T>(index, metadata.getIndex(), IndexStatus.UNHEALTHY);
                }
            }
            if (index.getVersion() > currentIndexVersion) {
                return new IndexState<T>(index, metadata.getIndex(), IndexStatus.NEEDS_VERSION_BUMP);
            }
            if (this.getIndexTemplateVersion() > currentTemplateVersion) {
                List<Migration> pendingMigrations = index.getMigrations(currentTemplateVersion);
                if (pendingMigrations.isEmpty()) {
                    logger.trace("Index [{}] with index template version [{}] (current is [{}]) is up-to-date (no pending migrations).", (Object)metadata.getIndex(), (Object)currentTemplateVersion, (Object)this.getIndexTemplateVersion());
                    return new IndexState<T>(index, metadata.getIndex(), IndexStatus.UP_TO_DATE);
                }
                logger.trace("Index [{}] with index template version [{}] (current is [{}])  has [{}] pending migrations.", (Object)metadata.getIndex(), (Object)currentTemplateVersion, (Object)this.getIndexTemplateVersion(), (Object)pendingMigrations.size());
                return new IndexState<T>(index, metadata.getIndex(), IndexStatus.NEEDS_MAPPINGS_UPDATE, pendingMigrations);
            }
            return new IndexState<T>(index, metadata.getIndex(), IndexStatus.UP_TO_DATE);
        }
        logger.warn("No mapping found for existing index [{}]. Index cannot be migrated.", (Object)metadata.getIndex());
        return new IndexState<T>(index, metadata.getIndex(), IndexStatus.UNHEALTHY);
    }

    private int getVersionField(Index index, Map<String, Object> meta, String fieldName) {
        Object value = meta.get(fieldName);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value == null) {
            logger.warn("Metadata version field [{}] of index [{}] is empty.", (Object)fieldName, (Object)index);
            return -1;
        }
        logger.warn("Metadata version field [{}] of index [{}] is [{}] (expected an integer).", (Object)fieldName, (Object)index, value);
        return -1;
    }

    protected int getIndexTemplateVersion() {
        return 12;
    }
}

