/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.profiling.action.NumberUtils;

public class GetFlamegraphResponse
extends ActionResponse
implements ChunkedToXContentObject {
    private final int size;
    private final double samplingRate;
    private final long selfCPU;
    private final long totalCPU;
    private final long totalSamples;
    private final List<Map<String, Integer>> edges;
    private final List<String> fileIds;
    private final List<Integer> frameTypes;
    private final List<Boolean> inlineFrames;
    private final List<String> fileNames;
    private final List<Integer> addressOrLines;
    private final List<String> functionNames;
    private final List<Integer> functionOffsets;
    private final List<String> sourceFileNames;
    private final List<Integer> sourceLines;
    private final List<Long> countInclusive;
    private final List<Long> countExclusive;
    private final List<Double> annualCO2TonsInclusive;
    private final List<Double> annualCO2TonsExclusive;
    private final List<Double> annualCostsUSDInclusive;
    private final List<Double> annualCostsUSDExclusive;

    public GetFlamegraphResponse(int size, double samplingRate, List<Map<String, Integer>> edges, List<String> fileIds, List<Integer> frameTypes, List<Boolean> inlineFrames, List<String> fileNames, List<Integer> addressOrLines, List<String> functionNames, List<Integer> functionOffsets, List<String> sourceFileNames, List<Integer> sourceLines, List<Long> countInclusive, List<Long> countExclusive, List<Double> annualCO2TonsInclusive, List<Double> annualCO2TonsExclusive, List<Double> annualCostsUSDInclusive, List<Double> annualCostsUSDExclusive, long selfCPU, long totalCPU, long totalSamples) {
        this.size = size;
        this.samplingRate = samplingRate;
        this.edges = edges;
        this.fileIds = fileIds;
        this.frameTypes = frameTypes;
        this.inlineFrames = inlineFrames;
        this.fileNames = fileNames;
        this.addressOrLines = addressOrLines;
        this.functionNames = functionNames;
        this.functionOffsets = functionOffsets;
        this.sourceFileNames = sourceFileNames;
        this.sourceLines = sourceLines;
        this.countInclusive = countInclusive;
        this.countExclusive = countExclusive;
        this.annualCO2TonsInclusive = annualCO2TonsInclusive;
        this.annualCO2TonsExclusive = annualCO2TonsExclusive;
        this.annualCostsUSDInclusive = annualCostsUSDInclusive;
        this.annualCostsUSDExclusive = annualCostsUSDExclusive;
        this.selfCPU = selfCPU;
        this.totalCPU = totalCPU;
        this.totalSamples = totalSamples;
    }

    public void writeTo(StreamOutput out) throws IOException {
        TransportAction.localOnly();
    }

    public int getSize() {
        return this.size;
    }

    public double getSamplingRate() {
        return this.samplingRate;
    }

    public List<Long> getCountInclusive() {
        return this.countInclusive;
    }

    public List<Long> getCountExclusive() {
        return this.countExclusive;
    }

    public List<Map<String, Integer>> getEdges() {
        return this.edges;
    }

    public List<String> getFileIds() {
        return this.fileIds;
    }

    public List<Integer> getFrameTypes() {
        return this.frameTypes;
    }

    public List<Boolean> getInlineFrames() {
        return this.inlineFrames;
    }

    public List<String> getFileNames() {
        return this.fileNames;
    }

    public List<Integer> getAddressOrLines() {
        return this.addressOrLines;
    }

    public List<String> getFunctionNames() {
        return this.functionNames;
    }

    public List<Integer> getFunctionOffsets() {
        return this.functionOffsets;
    }

    public List<String> getSourceFileNames() {
        return this.sourceFileNames;
    }

    public List<Integer> getSourceLines() {
        return this.sourceLines;
    }

    public List<Double> getAnnualCO2TonsInclusive() {
        return this.annualCO2TonsInclusive;
    }

    public List<Double> getAnnualCostsUSDInclusive() {
        return this.annualCostsUSDInclusive;
    }

    public long getSelfCPU() {
        return this.selfCPU;
    }

    public long getTotalCPU() {
        return this.totalCPU;
    }

    public long getTotalSamples() {
        return this.totalSamples;
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject(), ChunkedToXContentHelper.array((String)"Edges", (Iterator)Iterators.flatMap(this.edges.iterator(), perNodeEdges -> Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startArray(), Iterators.map(perNodeEdges.entrySet().iterator(), edge -> (b, p) -> b.value((Integer)edge.getValue())), ChunkedToXContentHelper.endArray()}))), ChunkedToXContentHelper.array((String)"FileID", (Iterator)Iterators.map(this.fileIds.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.array((String)"FrameType", (Iterator)Iterators.map(this.frameTypes.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.array((String)"Inline", (Iterator)Iterators.map(this.inlineFrames.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.array((String)"ExeFilename", (Iterator)Iterators.map(this.fileNames.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.array((String)"AddressOrLine", (Iterator)Iterators.map(this.addressOrLines.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.array((String)"FunctionName", (Iterator)Iterators.map(this.functionNames.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.singleChunk((b, p) -> {
            b.startArray("FunctionOffset");
            for (int functionOffset : this.functionOffsets) {
                b.value(functionOffset);
            }
            return b.endArray();
        }), ChunkedToXContentHelper.array((String)"SourceFilename", (Iterator)Iterators.map(this.sourceFileNames.iterator(), e -> (b, p) -> b.value(e))), ChunkedToXContentHelper.singleChunk((b, p) -> {
            b.startArray("SourceLine");
            for (int sourceLine : this.sourceLines) {
                b.value(sourceLine);
            }
            return b.endArray();
        }), ChunkedToXContentHelper.singleChunk((b, p) -> {
            b.startArray("CountInclusive");
            for (long countInclusive : this.countInclusive) {
                b.value(countInclusive);
            }
            return b.endArray();
        }), ChunkedToXContentHelper.singleChunk((b, p) -> {
            b.startArray("CountExclusive");
            for (long c : this.countExclusive) {
                b.value(c);
            }
            return b.endArray();
        }), ChunkedToXContentHelper.singleChunk((b, p) -> {
            b.startArray("AnnualCO2TonsInclusive");
            for (double co2Tons : this.annualCO2TonsInclusive) {
                b.rawValue(NumberUtils.doubleToString(co2Tons));
            }
            return b.endArray();
        }), ChunkedToXContentHelper.singleChunk((b, p) -> {
            b.startArray("AnnualCO2TonsExclusive");
            for (double co2Tons : this.annualCO2TonsExclusive) {
                b.rawValue(NumberUtils.doubleToString(co2Tons));
            }
            return b.endArray();
        }), ChunkedToXContentHelper.singleChunk((b, p) -> {
            b.startArray("AnnualCostsUSDInclusive");
            for (double costs : this.annualCostsUSDInclusive) {
                b.rawValue(NumberUtils.doubleToString(costs));
            }
            return b.endArray();
        }), ChunkedToXContentHelper.singleChunk((b, p) -> {
            b.startArray("AnnualCostsUSDExclusive");
            for (double costs : this.annualCostsUSDExclusive) {
                b.rawValue(NumberUtils.doubleToString(costs));
            }
            return b.endArray();
        }), Iterators.single((b, p) -> b.field("Size", this.size)), Iterators.single((b, p) -> b.field("SamplingRate", this.samplingRate)), Iterators.single((b, p) -> b.field("SelfCPU", this.selfCPU)), Iterators.single((b, p) -> b.field("TotalCPU", this.totalCPU)), Iterators.single((b, p) -> b.field("TotalSamples", this.totalSamples)), ChunkedToXContentHelper.endObject()});
    }
}

