/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.h3;

import org.elasticsearch.h3.Constants;
import org.elasticsearch.h3.CoordIJK;
import org.elasticsearch.h3.FaceIJK;
import org.elasticsearch.h3.FastMath;
import org.elasticsearch.h3.H3Index;
import org.elasticsearch.h3.LatLng;
import org.elasticsearch.h3.Vec2d;

final class Vec3d {
    public static final Vec3d[] faceCenterPoint = new Vec3d[]{new Vec3d(0.2199307791404606, 0.6583691780274996, 0.7198475378926182), new Vec3d(-0.2139234834501421, 0.1478171829550703, 0.9656017935214205), new Vec3d(0.1092625278784797, -0.481195157287321, 0.8697775121287253), new Vec3d(0.7428567301586791, -0.3593941678278028, 0.5648005936517033), new Vec3d(0.8112534709140969, 0.3448953237639384, 0.472138773641393), new Vec3d(-0.1055498149613921, 0.9794457296411413, 0.1718874610009365), new Vec3d(-0.8075407579970092, 0.1533552485898818, 0.5695261994882688), new Vec3d(-0.2846148069787907, -0.8644080972654206, 0.4144792552473539), new Vec3d(0.7405621473854482, -0.6673299564565524, -0.0789837646326737), new Vec3d(0.8512303986474293, 0.4722343788582681, -0.2289137388687808), new Vec3d(-0.7405621473854481, 0.6673299564565524, 0.0789837646326737), new Vec3d(-0.8512303986474292, -0.4722343788582682, 0.2289137388687808), new Vec3d(0.1055498149613919, -0.9794457296411413, -0.1718874610009365), new Vec3d(0.8075407579970092, -0.1533552485898819, -0.5695261994882688), new Vec3d(0.2846148069787908, 0.8644080972654204, -0.4144792552473539), new Vec3d(-0.7428567301586791, 0.3593941678278027, -0.5648005936517033), new Vec3d(-0.811253470914097, -0.3448953237639382, -0.472138773641393), new Vec3d(-0.2199307791404607, -0.6583691780274996, -0.7198475378926182), new Vec3d(0.213923483450142, -0.1478171829550704, -0.9656017935214205), new Vec3d(-0.1092625278784796, 0.481195157287321, -0.8697775121287253)};
    private final double x;
    private final double y;
    private final double z;

    private Vec3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    private double pointSquareDist(double x, double y, double z) {
        return Vec3d.square(x - this.x) + Vec3d.square(y - this.y) + Vec3d.square(z - this.z);
    }

    static long geoToH3(int res, double lat, double lon) {
        double cosLat = FastMath.cos(lat);
        double z = FastMath.sin(lat);
        double x = FastMath.cos(lon) * cosLat;
        double y = FastMath.sin(lon) * cosLat;
        int face = 0;
        double sqd = faceCenterPoint[0].pointSquareDist(x, y, z);
        for (int i = 1; i < faceCenterPoint.length; ++i) {
            double sqdT = faceCenterPoint[i].pointSquareDist(x, y, z);
            if (!(sqdT < sqd)) continue;
            face = i;
            sqd = sqdT;
        }
        double r = FastMath.acos(1.0 - sqd / 2.0);
        if (r < Constants.EPSILON) {
            return FaceIJK.faceIjkToH3(res, face, new CoordIJK(0, 0, 0));
        }
        double theta = Vec2d.posAngleRads(Vec2d.faceAxesAzRadsCII[face][0] - Vec2d.posAngleRads(faceCenterPoint[face].geoAzimuthRads(x, y, z)));
        if (H3Index.isResolutionClassIII(res)) {
            theta = Vec2d.posAngleRads(theta - Constants.M_AP7_ROT_RADS);
        }
        r = FastMath.tan(r);
        r /= Constants.RES0_U_GNOMONIC;
        for (int i = 0; i < res; ++i) {
            r *= 2.6457513110645907;
        }
        return FaceIJK.faceIjkToH3(res, face, Vec2d.hex2dToCoordIJK(r * FastMath.cos(theta), r * FastMath.sin(theta)));
    }

    private static double square(double x) {
        return x * x;
    }

    double geoAzimuthRads(double x, double y, double z) {
        double c1X = this.y * z - this.z * y;
        double c1Y = this.z * x - this.x * z;
        double c1Z = this.x * y - this.y * x;
        double c2X = this.y;
        double c2Y = -this.x;
        double c2Z = 0.0;
        double c1c2X = c1Y * 0.0 - c1Z * c2Y;
        double c1c2Y = c1Z * c2X - c1X * 0.0;
        double c1c2Z = c1X * c2Y - c1Y * c2X;
        double sign = Math.signum(Vec3d.dotProduct(this.x, this.y, this.z, c1c2X, c1c2Y, c1c2Z));
        return FastMath.atan2(sign * Vec3d.magnitude(c1c2X, c1c2Y, c1c2Z), Vec3d.dotProduct(c1X, c1Y, c1Z, c2X, c2Y, 0.0));
    }

    LatLng geoAzDistanceRads(double az, double distance) {
        az = Vec2d.posAngleRads(az);
        double magnitude = Vec3d.magnitude(this.x, this.y, 0.0);
        double deX = -this.y / magnitude;
        double deY = this.x / magnitude;
        double dnX = -this.z * deY;
        double dnY = this.z * deX;
        double dnZ = this.x * deY - this.y * deX;
        double sinAz = FastMath.sin(az);
        double cosAz = FastMath.cos(az);
        double sinDistance = FastMath.sin(distance);
        double cosDistance = FastMath.cos(distance);
        double dX = dnX * cosAz + deX * sinAz;
        double dY = dnY * cosAz + deY * sinAz;
        double dZ = dnZ * cosAz;
        double n2X = this.x * cosDistance + dX * sinDistance;
        double n2Y = this.y * cosDistance + dY * sinDistance;
        double n2Z = this.z * cosDistance + dZ * sinDistance;
        return new LatLng(FastMath.asin(n2Z), FastMath.atan2(n2Y, n2X));
    }

    private static double dotProduct(double x1, double y1, double z1, double x2, double y2, double z2) {
        return x1 * x2 + y1 * y2 + z1 * z2;
    }

    private static double magnitude(double x, double y, double z) {
        return Math.sqrt(Vec3d.square(x) + Vec3d.square(y) + Vec3d.square(z));
    }
}

