/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xpack.core.watcher.actions.Action;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.actions.webhook.WebhookAction;
import org.elasticsearch.xpack.watcher.common.http.HttpClient;
import org.elasticsearch.xpack.watcher.common.http.HttpRequest;
import org.elasticsearch.xpack.watcher.common.http.HttpResponse;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.notification.NotificationService;
import org.elasticsearch.xpack.watcher.support.Variables;

public class WebhookService
extends NotificationService<WebhookAccount> {
    public static final String NAME = "webhook";
    private static final Logger logger = LogManager.getLogger(WebhookService.class);
    public static final String TOKEN_HEADER_NAME = "X-Elastic-App-Auth";
    public static final Setting<SecureString> SETTING_WEBHOOK_HOST_TOKEN_PAIRS = SecureSetting.secureString((String)"xpack.notification.webhook.host_token_pairs", null, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<Boolean> SETTING_WEBHOOK_TOKEN_ENABLED = Setting.boolSetting((String)"xpack.notification.webhook.additional_token_enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final HttpClient httpClient;
    private final boolean additionalTokenEnabled;

    public WebhookService(Settings settings, HttpClient httpClient, ClusterSettings clusterSettings) {
        super(NAME, settings, clusterSettings, List.of(), WebhookService.getSecureSettings());
        this.httpClient = httpClient;
        this.reload(settings);
        this.additionalTokenEnabled = (Boolean)SETTING_WEBHOOK_TOKEN_ENABLED.get(settings);
    }

    public static List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList(WebhookService.getSecureSettings());
        settings.add(SETTING_WEBHOOK_TOKEN_ENABLED);
        return settings;
    }

    private static List<Setting<?>> getSecureSettings() {
        return List.of(SETTING_WEBHOOK_HOST_TOKEN_PAIRS);
    }

    @Override
    protected String getDefaultAccountName(Settings settings) {
        return NAME;
    }

    @Override
    protected WebhookAccount createAccount(String name, Settings accountSettings) {
        throw new UnsupportedOperationException("this should never be called");
    }

    @Override
    protected Map<String, LazyInitializable<WebhookAccount, SettingsException>> createAccounts(Settings settings, Set<String> accountNames, BiFunction<String, Settings, WebhookAccount> accountFactory) {
        WebhookAccount defaultAccount = new WebhookAccount(settings);
        return Map.of(NAME, new LazyInitializable(() -> defaultAccount));
    }

    public Action.Result execute(String actionId, WebhookAction action, TextTemplateEngine templateEngine, WatchExecutionContext ctx, Payload payload) throws IOException {
        Function<HttpRequest, HttpRequest> redactToken;
        Map<String, Object> model = Variables.createCtxParamsMap(ctx, payload);
        HttpRequest originalRequest = action.getRequest().render(templateEngine, model);
        if (ctx.simulateAction(actionId)) {
            HttpRequest request = this.maybeModifyHttpRequest(originalRequest);
            boolean tokenAdded = originalRequest != request;
            return new WebhookAction.Result.Simulated(tokenAdded ? request.copy().setHeader(TOKEN_HEADER_NAME, "::es_redacted::").build() : request);
        }
        Tuple<HttpRequest, HttpResponse> respTup = this.modifyAndExecuteHttpRequest(originalRequest);
        HttpRequest request = (HttpRequest)respTup.v1();
        HttpResponse response = (HttpResponse)respTup.v2();
        boolean tokenAdded = originalRequest != request;
        Function<HttpRequest, HttpRequest> function = redactToken = tokenAdded ? req -> req.copy().setHeader(TOKEN_HEADER_NAME, "::es_redacted::").build() : Function.identity();
        if (response.status() >= 400) {
            return new WebhookAction.Result.Failure(redactToken.apply(request), response);
        }
        return new WebhookAction.Result.Success(redactToken.apply(request), response);
    }

    HttpRequest maybeModifyHttpRequest(HttpRequest request) {
        String reqHostAndPort;
        WebhookAccount account = (WebhookAccount)this.getAccount(NAME);
        if (this.additionalTokenEnabled && account.hostTokenMap.size() > 0 && Strings.hasText((String)account.hostTokenMap.get(reqHostAndPort = request.host() + ":" + request.port()))) {
            logger.debug("additional [{}] header token added to watcher webhook request for {}://{}:{}", new Object[]{TOKEN_HEADER_NAME, request.scheme().scheme(), request.host(), request.port()});
            return request.copy().setHeader(TOKEN_HEADER_NAME, account.hostTokenMap.get(reqHostAndPort)).build();
        }
        return request;
    }

    public Tuple<HttpRequest, HttpResponse> modifyAndExecuteHttpRequest(HttpRequest request) throws IOException {
        HttpRequest modifiedRequest = this.maybeModifyHttpRequest(request);
        HttpResponse response = this.httpClient.execute(modifiedRequest);
        logger.debug("executed watcher webhook request for {}://{}:{}, response code: {}", new Object[]{modifiedRequest.scheme().scheme(), modifiedRequest.host(), modifiedRequest.port(), response.status()});
        return Tuple.tuple((Object)modifiedRequest, (Object)response);
    }

    public static final class WebhookAccount {
        private final Map<String, String> hostTokenMap;

        public WebhookAccount(Settings settings) {
            SecureString validTokenHosts = (SecureString)SETTING_WEBHOOK_HOST_TOKEN_PAIRS.get(settings);
            if (Strings.hasText((CharSequence)validTokenHosts)) {
                String hostPortToken;
                int equalsIndex;
                Set hostAndTokens = Strings.commaDelimitedListToSet((String)validTokenHosts.toString());
                HashMap<String, String> hostAndPortToToken = new HashMap<String, String>(hostAndTokens.size());
                Iterator iterator = hostAndTokens.iterator();
                while (iterator.hasNext() && (equalsIndex = (hostPortToken = (String)iterator.next()).indexOf(61)) != -1 && equalsIndex + 1 != hostPortToken.length()) {
                    String hostAndPort = hostPortToken.substring(0, equalsIndex);
                    String token = hostPortToken.substring(equalsIndex + 1);
                    hostAndPortToToken.put(hostAndPort, token);
                }
                this.hostTokenMap = Collections.unmodifiableMap(hostAndPortToToken);
            } else {
                this.hostTokenMap = Map.of();
            }
        }

        public String toString() {
            return "WebhookAccount[" + this.hostTokenMap.keySet().stream().map(s -> s + "=********") + "]";
        }
    }
}

