/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.server.cli;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.SuppressForbidden;

final class SystemJvmOptions {
    SystemJvmOptions() {
    }

    static List<String> systemJvmOptions(Settings nodeSettings, Map<String, String> sysprops) {
        String distroType = sysprops.get("es.distribution.type");
        boolean isHotspot = sysprops.getOrDefault("sun.management.compiler", "").contains("HotSpot");
        String libraryPath = SystemJvmOptions.findLibraryPath(sysprops);
        return Stream.concat(Stream.of("-Des.networkaddress.cache.ttl=60", "-Des.networkaddress.cache.negative.ttl=10", "-Djava.security.manager=allow", "-XX:+AlwaysPreTouch", "-Xss1m", "-Djava.awt.headless=true", "-Dfile.encoding=UTF-8", "-Djna.nosys=true", "-XX:-OmitStackTraceInFastThrow", "-Dio.netty.noUnsafe=true", "-Dio.netty.noKeySetOptimization=true", "-Dio.netty.recycler.maxCapacityPerThread=0", "-Dlog4j.shutdownHookEnabled=false", "-Dlog4j2.disable.jmx=true", "-Dlog4j2.formatMsgNoLookups=true", "-Djava.locale.providers=SPI,COMPAT", "--add-opens=java.base/java.io=org.elasticsearch.preallocate", SystemJvmOptions.maybeEnableNativeAccess(), SystemJvmOptions.maybeOverrideDockerCgroup(distroType), SystemJvmOptions.maybeSetActiveProcessorCount(nodeSettings), SystemJvmOptions.setReplayFile(distroType, isHotspot), "-Djava.library.path=" + libraryPath, "-Djna.library.path=" + libraryPath, "-Des.distribution.type=" + distroType), SystemJvmOptions.maybeWorkaroundG1Bug()).filter(e -> !e.isEmpty()).collect(Collectors.toList());
    }

    private static String maybeOverrideDockerCgroup(String distroType) {
        if ("docker".equals(distroType)) {
            return "-Des.cgroups.hierarchy.override=/";
        }
        return "";
    }

    private static String setReplayFile(String distroType, boolean isHotspot) {
        if (!isHotspot) {
            return "";
        }
        String replayDir = "logs";
        if ("rpm".equals(distroType) || "deb".equals(distroType)) {
            replayDir = "/var/log/elasticsearch";
        }
        return "-XX:ReplayDataFile=" + replayDir + "/replay_pid%p.log";
    }

    private static String maybeSetActiveProcessorCount(Settings nodeSettings) {
        if (EsExecutors.NODE_PROCESSORS_SETTING.exists(nodeSettings)) {
            int allocated = EsExecutors.allocatedProcessors((Settings)nodeSettings);
            return "-XX:ActiveProcessorCount=" + allocated;
        }
        return "";
    }

    private static String maybeEnableNativeAccess() {
        if (Runtime.version().feature() >= 21) {
            return "--enable-native-access=org.elasticsearch.nativeaccess,org.apache.lucene.core";
        }
        return "";
    }

    private static Stream<String> maybeWorkaroundG1Bug() {
        Runtime.Version v = Runtime.version();
        if (v.feature() == 22 && v.update() <= 1) {
            return Stream.of("-XX:+UnlockDiagnosticVMOptions", "-XX:G1NumCollectionsKeepPinned=10000000");
        }
        return Stream.of(new String[0]);
    }

    private static String findLibraryPath(Map<String, String> sysprops) {
        Path platformDir = Paths.get("lib", "platform");
        String existingPath = sysprops.get("java.library.path");
        assert (existingPath != null);
        String osname = sysprops.get("os.name");
        Object os = osname.startsWith("Windows") ? "windows" : (osname.startsWith("Linux") ? "linux" : (osname.startsWith("Mac OS") ? "darwin" : "unsupported_os[" + osname + "]"));
        String archname = sysprops.get("os.arch");
        Object arch = archname.equals("amd64") || archname.equals("x86_64") ? "x64" : (archname.equals("aarch64") ? archname : "unsupported_arch[" + archname + "]");
        return platformDir.resolve((String)os + "-" + (String)arch).toAbsolutePath() + SystemJvmOptions.getPathSeparator() + existingPath;
    }

    @SuppressForbidden(reason="no way to get path separator with nio")
    private static String getPathSeparator() {
        return File.pathSeparator;
    }
}

