/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.support.StringMatcher;

public class RemoteClusterPermissionGroup
implements NamedWriteable,
ToXContentObject {
    public static final String NAME = "remote_cluster_permission_group";
    private final String[] clusterPrivileges;
    private final String[] remoteClusterAliases;
    private final StringMatcher remoteClusterAliasMatcher;

    public RemoteClusterPermissionGroup(StreamInput in) throws IOException {
        this.clusterPrivileges = in.readStringArray();
        this.remoteClusterAliases = in.readStringArray();
        this.remoteClusterAliasMatcher = StringMatcher.of(this.remoteClusterAliases);
    }

    public RemoteClusterPermissionGroup(String[] clusterPrivileges, String[] remoteClusterAliases) {
        if (clusterPrivileges == null || remoteClusterAliases == null || clusterPrivileges.length <= 0 || remoteClusterAliases.length <= 0) {
            throw new IllegalArgumentException("remote cluster groups must not be null or empty");
        }
        if (Arrays.stream(clusterPrivileges).anyMatch(s -> !Strings.hasText((String)s))) {
            throw new IllegalArgumentException("remote_cluster privileges must contain valid non-empty, non-null values");
        }
        if (Arrays.stream(remoteClusterAliases).anyMatch(s -> !Strings.hasText((String)s))) {
            throw new IllegalArgumentException("remote_cluster clusters aliases must contain valid non-empty, non-null values");
        }
        this.clusterPrivileges = clusterPrivileges;
        this.remoteClusterAliases = remoteClusterAliases;
        this.remoteClusterAliasMatcher = StringMatcher.of(remoteClusterAliases);
    }

    public boolean hasPrivileges(String remoteClusterAlias) {
        return this.remoteClusterAliasMatcher.test(remoteClusterAlias);
    }

    public String[] clusterPrivileges() {
        return Arrays.copyOf(this.clusterPrivileges, this.clusterPrivileges.length);
    }

    public String[] remoteClusterAliases() {
        return Arrays.copyOf(this.remoteClusterAliases, this.remoteClusterAliases.length);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.array(RoleDescriptor.Fields.PRIVILEGES.getPreferredName(), this.clusterPrivileges);
        builder.array(RoleDescriptor.Fields.CLUSTERS.getPreferredName(), this.remoteClusterAliases);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.clusterPrivileges);
        out.writeStringArray(this.remoteClusterAliases);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteClusterPermissionGroup that = (RemoteClusterPermissionGroup)o;
        return Arrays.equals(this.clusterPrivileges, that.clusterPrivileges) && Arrays.equals(this.remoteClusterAliases, that.remoteClusterAliases);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.clusterPrivileges);
        result = 31 * result + Arrays.hashCode(this.remoteClusterAliases);
        return result;
    }

    public String toString() {
        return "RemoteClusterPermissionGroup{privileges=" + Arrays.toString(this.clusterPrivileges) + ", clusters=" + Arrays.toString(this.remoteClusterAliases) + "}";
    }

    public String getWriteableName() {
        return NAME;
    }
}

