/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.SimpleBatchedExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.UpdateIndexMigrationVersionResponse;

public class UpdateIndexMigrationVersionAction
extends ActionType<UpdateIndexMigrationVersionResponse> {
    public static final UpdateIndexMigrationVersionAction INSTANCE = new UpdateIndexMigrationVersionAction();
    public static final String NAME = "internal:index/metadata/migration_version/update";
    public static final String MIGRATION_VERSION_CUSTOM_KEY = "migration_version";
    public static final String MIGRATION_VERSION_CUSTOM_DATA_KEY = "version";

    public UpdateIndexMigrationVersionAction() {
        super(NAME);
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, UpdateIndexMigrationVersionResponse> {
        private final MasterServiceTaskQueue<UpdateIndexMigrationVersionTask> updateIndexMigrationVersionTaskQueue;
        private static final SimpleBatchedExecutor<UpdateIndexMigrationVersionTask, Void> UPDATE_INDEX_MIGRATION_VERSION_TASK_EXECUTOR = new SimpleBatchedExecutor<UpdateIndexMigrationVersionTask, Void>(){

            public Tuple<ClusterState, Void> executeTask(UpdateIndexMigrationVersionTask task, ClusterState clusterState) {
                return Tuple.tuple((Object)task.execute(clusterState), null);
            }

            public void taskSucceeded(UpdateIndexMigrationVersionTask task, Void unused) {
                task.listener.onResponse(null);
            }
        };

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(UpdateIndexMigrationVersionAction.NAME, transportService, clusterService, threadPool, actionFilters, Request::new, indexNameExpressionResolver, UpdateIndexMigrationVersionResponse::new, (Executor)threadPool.executor("management"));
            this.updateIndexMigrationVersionTaskQueue = clusterService.createTaskQueue("update-index-migration-version-task-queue", Priority.LOW, UPDATE_INDEX_MIGRATION_VERSION_TASK_EXECUTOR);
        }

        protected void masterOperation(Task task, Request request, ClusterState state, ActionListener<UpdateIndexMigrationVersionResponse> listener) throws Exception {
            this.updateIndexMigrationVersionTaskQueue.submitTask("Updating cluster state with a new index migration version", (ClusterStateTaskListener)new UpdateIndexMigrationVersionTask((ActionListener<Void>)ActionListener.wrap(response -> listener.onResponse((Object)new UpdateIndexMigrationVersionResponse()), arg_0 -> listener.onFailure(arg_0)), request.getIndexMigrationVersion(), request.getIndexName()), null);
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, new String[]{request.getIndexName()});
        }

        static class UpdateIndexMigrationVersionTask
        implements ClusterStateTaskListener {
            private final ActionListener<Void> listener;
            private final int indexMigrationVersion;
            private final String indexName;

            UpdateIndexMigrationVersionTask(ActionListener<Void> listener, int indexMigrationVersion, String indexName) {
                this.listener = listener;
                this.indexMigrationVersion = indexMigrationVersion;
                this.indexName = indexName;
            }

            ClusterState execute(ClusterState currentState) {
                IndexMetadata.Builder indexMetadataBuilder = IndexMetadata.builder((IndexMetadata)((IndexMetadata)currentState.metadata().getIndices().get(this.indexName)));
                indexMetadataBuilder.putCustom(UpdateIndexMigrationVersionAction.MIGRATION_VERSION_CUSTOM_KEY, Map.of(UpdateIndexMigrationVersionAction.MIGRATION_VERSION_CUSTOM_DATA_KEY, Integer.toString(this.indexMigrationVersion)));
                indexMetadataBuilder.version(indexMetadataBuilder.version() + 1L);
                ImmutableOpenMap.Builder builder = ImmutableOpenMap.builder((Map)currentState.metadata().getIndices());
                builder.put((Object)this.indexName, (Object)indexMetadataBuilder.build());
                return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentState.metadata()).indices((Map)builder.build()).build()).build();
            }

            public void onFailure(Exception e) {
                this.listener.onFailure(e);
            }
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private final int indexMigrationVersion;
        private final String indexName;

        public Request(TimeValue timeout, int indexMigrationVersion, String indexName) {
            super(timeout);
            this.indexMigrationVersion = indexMigrationVersion;
            this.indexName = indexName;
        }

        protected Request(StreamInput in) throws IOException {
            super(in);
            this.indexMigrationVersion = in.readInt();
            this.indexName = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.indexMigrationVersion);
            out.writeString(this.indexName);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public int getIndexMigrationVersion() {
            return this.indexMigrationVersion;
        }

        public String getIndexName() {
            return this.indexName;
        }
    }
}

