/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.process.autodetect.state;

import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.CategorizationStatus;
import org.elasticsearch.xpack.core.ml.job.results.Result;

public class ModelSizeStats
implements ToXContentObject,
Writeable {
    public static final String RESULT_TYPE_VALUE = "model_size_stats";
    public static final ParseField RESULT_TYPE_FIELD = new ParseField("model_size_stats", new String[0]);
    public static final ParseField MODEL_BYTES_FIELD = new ParseField("model_bytes", new String[0]);
    public static final ParseField PEAK_MODEL_BYTES_FIELD = new ParseField("peak_model_bytes", new String[0]);
    public static final ParseField MODEL_BYTES_EXCEEDED_FIELD = new ParseField("model_bytes_exceeded", new String[0]);
    public static final ParseField MODEL_BYTES_MEMORY_LIMIT_FIELD = new ParseField("model_bytes_memory_limit", new String[0]);
    public static final ParseField TOTAL_BY_FIELD_COUNT_FIELD = new ParseField("total_by_field_count", new String[0]);
    public static final ParseField TOTAL_OVER_FIELD_COUNT_FIELD = new ParseField("total_over_field_count", new String[0]);
    public static final ParseField TOTAL_PARTITION_FIELD_COUNT_FIELD = new ParseField("total_partition_field_count", new String[0]);
    public static final ParseField BUCKET_ALLOCATION_FAILURES_COUNT_FIELD = new ParseField("bucket_allocation_failures_count", new String[0]);
    public static final ParseField MEMORY_STATUS_FIELD = new ParseField("memory_status", new String[0]);
    public static final ParseField ASSIGNMENT_MEMORY_BASIS_FIELD = new ParseField("assignment_memory_basis", new String[0]);
    public static final ParseField OUTPUT_MEMORY_ALLOCATOR_BYTES_FIELD = new ParseField("output_memory_allocator_bytes", new String[0]);
    public static final ParseField CATEGORIZED_DOC_COUNT_FIELD = new ParseField("categorized_doc_count", new String[0]);
    public static final ParseField TOTAL_CATEGORY_COUNT_FIELD = new ParseField("total_category_count", new String[0]);
    public static final ParseField FREQUENT_CATEGORY_COUNT_FIELD = new ParseField("frequent_category_count", new String[0]);
    public static final ParseField RARE_CATEGORY_COUNT_FIELD = new ParseField("rare_category_count", new String[0]);
    public static final ParseField DEAD_CATEGORY_COUNT_FIELD = new ParseField("dead_category_count", new String[0]);
    public static final ParseField FAILED_CATEGORY_COUNT_FIELD = new ParseField("failed_category_count", new String[0]);
    public static final ParseField CATEGORIZATION_STATUS_FIELD = new ParseField("categorization_status", new String[0]);
    public static final ParseField LOG_TIME_FIELD = new ParseField("log_time", new String[0]);
    public static final ParseField TIMESTAMP_FIELD = new ParseField("timestamp", new String[0]);
    public static final ConstructingObjectParser<Builder, Void> STRICT_PARSER = ModelSizeStats.createParser(false);
    public static final ConstructingObjectParser<Builder, Void> LENIENT_PARSER = ModelSizeStats.createParser(true);
    private final String jobId;
    private final long modelBytes;
    private final Long peakModelBytes;
    private final Long modelBytesExceeded;
    private final Long modelBytesMemoryLimit;
    private final long totalByFieldCount;
    private final long totalOverFieldCount;
    private final long totalPartitionFieldCount;
    private final long bucketAllocationFailuresCount;
    private final MemoryStatus memoryStatus;
    private final AssignmentMemoryBasis assignmentMemoryBasis;
    private final Long outputMemoryAllocatorBytes;
    private final long categorizedDocCount;
    private final long totalCategoryCount;
    private final long frequentCategoryCount;
    private final long rareCategoryCount;
    private final long deadCategoryCount;
    private final long failedCategoryCount;
    private final CategorizationStatus categorizationStatus;
    private final Date timestamp;
    private final Date logTime;

    private static ConstructingObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(RESULT_TYPE_FIELD.getPreferredName(), ignoreUnknownFields, a -> new Builder((String)a[0]));
        parser.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        parser.declareString((modelSizeStat, s) -> {}, Result.RESULT_TYPE);
        parser.declareLong(Builder::setModelBytes, MODEL_BYTES_FIELD);
        parser.declareLong(Builder::setPeakModelBytes, PEAK_MODEL_BYTES_FIELD);
        parser.declareLong(Builder::setModelBytesExceeded, MODEL_BYTES_EXCEEDED_FIELD);
        parser.declareLong(Builder::setModelBytesMemoryLimit, MODEL_BYTES_MEMORY_LIMIT_FIELD);
        parser.declareLong(Builder::setBucketAllocationFailuresCount, BUCKET_ALLOCATION_FAILURES_COUNT_FIELD);
        parser.declareLong(Builder::setTotalByFieldCount, TOTAL_BY_FIELD_COUNT_FIELD);
        parser.declareLong(Builder::setTotalOverFieldCount, TOTAL_OVER_FIELD_COUNT_FIELD);
        parser.declareLong(Builder::setTotalPartitionFieldCount, TOTAL_PARTITION_FIELD_COUNT_FIELD);
        parser.declareField(Builder::setMemoryStatus, p -> MemoryStatus.fromString(p.text()), MEMORY_STATUS_FIELD, ObjectParser.ValueType.STRING);
        parser.declareField(Builder::setAssignmentMemoryBasis, p -> AssignmentMemoryBasis.fromString(p.text()), ASSIGNMENT_MEMORY_BASIS_FIELD, ObjectParser.ValueType.STRING);
        parser.declareLong(Builder::setOutputMemoryAllocatorBytes, OUTPUT_MEMORY_ALLOCATOR_BYTES_FIELD);
        parser.declareLong(Builder::setCategorizedDocCount, CATEGORIZED_DOC_COUNT_FIELD);
        parser.declareLong(Builder::setTotalCategoryCount, TOTAL_CATEGORY_COUNT_FIELD);
        parser.declareLong(Builder::setFrequentCategoryCount, FREQUENT_CATEGORY_COUNT_FIELD);
        parser.declareLong(Builder::setRareCategoryCount, RARE_CATEGORY_COUNT_FIELD);
        parser.declareLong(Builder::setDeadCategoryCount, DEAD_CATEGORY_COUNT_FIELD);
        parser.declareLong(Builder::setFailedCategoryCount, FAILED_CATEGORY_COUNT_FIELD);
        parser.declareField(Builder::setCategorizationStatus, p -> CategorizationStatus.fromString(p.text()), CATEGORIZATION_STATUS_FIELD, ObjectParser.ValueType.STRING);
        parser.declareField(Builder::setLogTime, p -> TimeUtils.parseTimeField(p, LOG_TIME_FIELD.getPreferredName()), LOG_TIME_FIELD, ObjectParser.ValueType.VALUE);
        parser.declareField(Builder::setTimestamp, p -> TimeUtils.parseTimeField(p, TIMESTAMP_FIELD.getPreferredName()), TIMESTAMP_FIELD, ObjectParser.ValueType.VALUE);
        return parser;
    }

    private ModelSizeStats(String jobId, long modelBytes, Long peakModelBytes, Long modelBytesExceeded, Long modelBytesMemoryLimit, long totalByFieldCount, long totalOverFieldCount, long totalPartitionFieldCount, long bucketAllocationFailuresCount, MemoryStatus memoryStatus, AssignmentMemoryBasis assignmentMemoryBasis, Long outputMemoryAllocatorBytes, long categorizedDocCount, long totalCategoryCount, long frequentCategoryCount, long rareCategoryCount, long deadCategoryCount, long failedCategoryCount, CategorizationStatus categorizationStatus, Date timestamp, Date logTime) {
        this.jobId = jobId;
        this.modelBytes = modelBytes;
        this.peakModelBytes = peakModelBytes;
        this.modelBytesExceeded = modelBytesExceeded;
        this.modelBytesMemoryLimit = modelBytesMemoryLimit;
        this.totalByFieldCount = totalByFieldCount;
        this.totalOverFieldCount = totalOverFieldCount;
        this.totalPartitionFieldCount = totalPartitionFieldCount;
        this.bucketAllocationFailuresCount = bucketAllocationFailuresCount;
        this.memoryStatus = memoryStatus;
        this.assignmentMemoryBasis = assignmentMemoryBasis;
        this.outputMemoryAllocatorBytes = outputMemoryAllocatorBytes;
        this.categorizedDocCount = categorizedDocCount;
        this.totalCategoryCount = totalCategoryCount;
        this.frequentCategoryCount = frequentCategoryCount;
        this.rareCategoryCount = rareCategoryCount;
        this.deadCategoryCount = deadCategoryCount;
        this.failedCategoryCount = failedCategoryCount;
        this.categorizationStatus = categorizationStatus;
        this.timestamp = timestamp;
        this.logTime = logTime;
    }

    public ModelSizeStats(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.modelBytes = in.readVLong();
        this.peakModelBytes = in.readOptionalLong();
        this.modelBytesExceeded = in.readOptionalLong();
        this.modelBytesMemoryLimit = in.readOptionalLong();
        this.totalByFieldCount = in.readVLong();
        this.totalOverFieldCount = in.readVLong();
        this.totalPartitionFieldCount = in.readVLong();
        this.bucketAllocationFailuresCount = in.readVLong();
        this.memoryStatus = MemoryStatus.readFromStream(in);
        this.assignmentMemoryBasis = in.readBoolean() ? AssignmentMemoryBasis.readFromStream(in) : null;
        this.outputMemoryAllocatorBytes = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ML_AD_OUTPUT_MEMORY_ALLOCATOR_FIELD) ? in.readOptionalVLong() : null;
        this.categorizedDocCount = in.readVLong();
        this.totalCategoryCount = in.readVLong();
        this.frequentCategoryCount = in.readVLong();
        this.rareCategoryCount = in.readVLong();
        this.deadCategoryCount = in.readVLong();
        this.failedCategoryCount = in.readVLong();
        this.categorizationStatus = CategorizationStatus.readFromStream(in);
        this.logTime = new Date(in.readVLong());
        this.timestamp = in.readBoolean() ? new Date(in.readVLong()) : null;
    }

    public String getId() {
        return ModelSizeStats.documentIdPrefix(this.jobId) + this.logTime.getTime();
    }

    public static String documentIdPrefix(String jobId) {
        return jobId + "_model_size_stats_";
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeVLong(this.modelBytes);
        out.writeOptionalLong(this.peakModelBytes);
        out.writeOptionalLong(this.modelBytesExceeded);
        out.writeOptionalLong(this.modelBytesMemoryLimit);
        out.writeVLong(this.totalByFieldCount);
        out.writeVLong(this.totalOverFieldCount);
        out.writeVLong(this.totalPartitionFieldCount);
        out.writeVLong(this.bucketAllocationFailuresCount);
        this.memoryStatus.writeTo(out);
        if (this.assignmentMemoryBasis != null) {
            out.writeBoolean(true);
            this.assignmentMemoryBasis.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ML_AD_OUTPUT_MEMORY_ALLOCATOR_FIELD)) {
            out.writeOptionalVLong(this.outputMemoryAllocatorBytes);
        }
        out.writeVLong(this.categorizedDocCount);
        out.writeVLong(this.totalCategoryCount);
        out.writeVLong(this.frequentCategoryCount);
        out.writeVLong(this.rareCategoryCount);
        out.writeVLong(this.deadCategoryCount);
        out.writeVLong(this.failedCategoryCount);
        this.categorizationStatus.writeTo(out);
        out.writeVLong(this.logTime.getTime());
        boolean hasTimestamp = this.timestamp != null;
        out.writeBoolean(hasTimestamp);
        if (hasTimestamp) {
            out.writeVLong(this.timestamp.getTime());
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.doXContentBody(builder);
        builder.endObject();
        return builder;
    }

    public XContentBuilder doXContentBody(XContentBuilder builder) throws IOException {
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(Result.RESULT_TYPE.getPreferredName(), RESULT_TYPE_VALUE);
        builder.field(MODEL_BYTES_FIELD.getPreferredName(), this.modelBytes);
        if (this.peakModelBytes != null) {
            builder.field(PEAK_MODEL_BYTES_FIELD.getPreferredName(), this.peakModelBytes);
        }
        if (this.modelBytesExceeded != null) {
            builder.field(MODEL_BYTES_EXCEEDED_FIELD.getPreferredName(), this.modelBytesExceeded);
        }
        if (this.modelBytesMemoryLimit != null) {
            builder.field(MODEL_BYTES_MEMORY_LIMIT_FIELD.getPreferredName(), this.modelBytesMemoryLimit);
        }
        builder.field(TOTAL_BY_FIELD_COUNT_FIELD.getPreferredName(), this.totalByFieldCount);
        builder.field(TOTAL_OVER_FIELD_COUNT_FIELD.getPreferredName(), this.totalOverFieldCount);
        builder.field(TOTAL_PARTITION_FIELD_COUNT_FIELD.getPreferredName(), this.totalPartitionFieldCount);
        builder.field(BUCKET_ALLOCATION_FAILURES_COUNT_FIELD.getPreferredName(), this.bucketAllocationFailuresCount);
        builder.field(MEMORY_STATUS_FIELD.getPreferredName(), (Enum)this.memoryStatus);
        if (this.assignmentMemoryBasis != null) {
            builder.field(ASSIGNMENT_MEMORY_BASIS_FIELD.getPreferredName(), (Enum)this.assignmentMemoryBasis);
        }
        if (this.outputMemoryAllocatorBytes != null) {
            builder.field(OUTPUT_MEMORY_ALLOCATOR_BYTES_FIELD.getPreferredName(), this.outputMemoryAllocatorBytes);
        }
        builder.field(CATEGORIZED_DOC_COUNT_FIELD.getPreferredName(), this.categorizedDocCount);
        builder.field(TOTAL_CATEGORY_COUNT_FIELD.getPreferredName(), this.totalCategoryCount);
        builder.field(FREQUENT_CATEGORY_COUNT_FIELD.getPreferredName(), this.frequentCategoryCount);
        builder.field(RARE_CATEGORY_COUNT_FIELD.getPreferredName(), this.rareCategoryCount);
        builder.field(DEAD_CATEGORY_COUNT_FIELD.getPreferredName(), this.deadCategoryCount);
        builder.field(FAILED_CATEGORY_COUNT_FIELD.getPreferredName(), this.failedCategoryCount);
        builder.field(CATEGORIZATION_STATUS_FIELD.getPreferredName(), (Enum)this.categorizationStatus);
        builder.timeField(LOG_TIME_FIELD.getPreferredName(), LOG_TIME_FIELD.getPreferredName() + "_string", this.logTime.getTime());
        if (this.timestamp != null) {
            builder.timeField(TIMESTAMP_FIELD.getPreferredName(), TIMESTAMP_FIELD.getPreferredName() + "_string", this.timestamp.getTime());
        }
        return builder;
    }

    public String getJobId() {
        return this.jobId;
    }

    public long getModelBytes() {
        return this.modelBytes;
    }

    public Long getPeakModelBytes() {
        return this.peakModelBytes;
    }

    public Long getModelBytesExceeded() {
        return this.modelBytesExceeded;
    }

    public Long getModelBytesMemoryLimit() {
        return this.modelBytesMemoryLimit;
    }

    public long getTotalByFieldCount() {
        return this.totalByFieldCount;
    }

    public long getTotalPartitionFieldCount() {
        return this.totalPartitionFieldCount;
    }

    public long getTotalOverFieldCount() {
        return this.totalOverFieldCount;
    }

    public long getBucketAllocationFailuresCount() {
        return this.bucketAllocationFailuresCount;
    }

    public MemoryStatus getMemoryStatus() {
        return this.memoryStatus;
    }

    @Nullable
    public AssignmentMemoryBasis getAssignmentMemoryBasis() {
        return this.assignmentMemoryBasis;
    }

    public Long getOutputMemmoryAllocatorBytes() {
        return this.outputMemoryAllocatorBytes;
    }

    public long getCategorizedDocCount() {
        return this.categorizedDocCount;
    }

    public long getTotalCategoryCount() {
        return this.totalCategoryCount;
    }

    public long getFrequentCategoryCount() {
        return this.frequentCategoryCount;
    }

    public long getRareCategoryCount() {
        return this.rareCategoryCount;
    }

    public long getDeadCategoryCount() {
        return this.deadCategoryCount;
    }

    public long getFailedCategoryCount() {
        return this.deadCategoryCount;
    }

    public CategorizationStatus getCategorizationStatus() {
        return this.categorizationStatus;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Date getLogTime() {
        return this.logTime;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.modelBytes, this.peakModelBytes, this.modelBytesExceeded, this.modelBytesMemoryLimit, this.totalByFieldCount, this.totalOverFieldCount, this.totalPartitionFieldCount, this.bucketAllocationFailuresCount, this.memoryStatus, this.assignmentMemoryBasis, this.outputMemoryAllocatorBytes, this.categorizedDocCount, this.totalCategoryCount, this.frequentCategoryCount, this.rareCategoryCount, this.deadCategoryCount, this.failedCategoryCount, this.categorizationStatus, this.timestamp, this.logTime});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModelSizeStats)) {
            return false;
        }
        ModelSizeStats that = (ModelSizeStats)other;
        return this.modelBytes == that.modelBytes && Objects.equals(this.peakModelBytes, that.peakModelBytes) && Objects.equals(this.modelBytesExceeded, that.modelBytesExceeded) && Objects.equals(this.modelBytesMemoryLimit, that.modelBytesMemoryLimit) && this.totalByFieldCount == that.totalByFieldCount && this.totalOverFieldCount == that.totalOverFieldCount && this.totalPartitionFieldCount == that.totalPartitionFieldCount && this.bucketAllocationFailuresCount == that.bucketAllocationFailuresCount && Objects.equals((Object)this.memoryStatus, (Object)that.memoryStatus) && Objects.equals((Object)this.assignmentMemoryBasis, (Object)that.assignmentMemoryBasis) && Objects.equals(this.outputMemoryAllocatorBytes, that.outputMemoryAllocatorBytes) && Objects.equals(this.categorizedDocCount, that.categorizedDocCount) && Objects.equals(this.totalCategoryCount, that.totalCategoryCount) && Objects.equals(this.frequentCategoryCount, that.frequentCategoryCount) && Objects.equals(this.rareCategoryCount, that.rareCategoryCount) && Objects.equals(this.deadCategoryCount, that.deadCategoryCount) && Objects.equals(this.failedCategoryCount, that.failedCategoryCount) && Objects.equals((Object)this.categorizationStatus, (Object)that.categorizationStatus) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.logTime, that.logTime) && Objects.equals(this.jobId, that.jobId);
    }

    public static enum MemoryStatus implements Writeable
    {
        OK,
        SOFT_LIMIT,
        HARD_LIMIT;


        public static MemoryStatus fromString(String statusName) {
            return MemoryStatus.valueOf(statusName.trim().toUpperCase(Locale.ROOT));
        }

        public static MemoryStatus readFromStream(StreamInput in) throws IOException {
            return (MemoryStatus)in.readEnum(MemoryStatus.class);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum AssignmentMemoryBasis implements Writeable
    {
        MODEL_MEMORY_LIMIT,
        CURRENT_MODEL_BYTES,
        PEAK_MODEL_BYTES;


        public static AssignmentMemoryBasis fromString(String statusName) {
            return AssignmentMemoryBasis.valueOf(statusName.trim().toUpperCase(Locale.ROOT));
        }

        public static AssignmentMemoryBasis readFromStream(StreamInput in) throws IOException {
            return (AssignmentMemoryBasis)in.readEnum(AssignmentMemoryBasis.class);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class Builder {
        private final String jobId;
        private long modelBytes;
        private Long peakModelBytes;
        private Long modelBytesExceeded;
        private Long modelBytesMemoryLimit;
        private long totalByFieldCount;
        private long totalOverFieldCount;
        private long totalPartitionFieldCount;
        private long bucketAllocationFailuresCount;
        private MemoryStatus memoryStatus;
        private AssignmentMemoryBasis assignmentMemoryBasis;
        private Long outputMemoryAllocatorBytes;
        private long categorizedDocCount;
        private long totalCategoryCount;
        private long frequentCategoryCount;
        private long rareCategoryCount;
        private long deadCategoryCount;
        private long failedCategoryCount;
        private CategorizationStatus categorizationStatus;
        private Date timestamp;
        private Date logTime;

        public Builder(String jobId) {
            this.jobId = jobId;
            this.memoryStatus = MemoryStatus.OK;
            this.categorizationStatus = CategorizationStatus.OK;
            this.logTime = new Date();
        }

        public Builder(ModelSizeStats modelSizeStats) {
            this.jobId = modelSizeStats.jobId;
            this.modelBytes = modelSizeStats.modelBytes;
            this.peakModelBytes = modelSizeStats.peakModelBytes;
            this.modelBytesExceeded = modelSizeStats.modelBytesExceeded;
            this.modelBytesMemoryLimit = modelSizeStats.modelBytesMemoryLimit;
            this.totalByFieldCount = modelSizeStats.totalByFieldCount;
            this.totalOverFieldCount = modelSizeStats.totalOverFieldCount;
            this.totalPartitionFieldCount = modelSizeStats.totalPartitionFieldCount;
            this.bucketAllocationFailuresCount = modelSizeStats.bucketAllocationFailuresCount;
            this.memoryStatus = modelSizeStats.memoryStatus;
            this.assignmentMemoryBasis = modelSizeStats.assignmentMemoryBasis;
            this.outputMemoryAllocatorBytes = modelSizeStats.outputMemoryAllocatorBytes;
            this.categorizedDocCount = modelSizeStats.categorizedDocCount;
            this.totalCategoryCount = modelSizeStats.totalCategoryCount;
            this.frequentCategoryCount = modelSizeStats.frequentCategoryCount;
            this.rareCategoryCount = modelSizeStats.rareCategoryCount;
            this.deadCategoryCount = modelSizeStats.deadCategoryCount;
            this.failedCategoryCount = modelSizeStats.failedCategoryCount;
            this.categorizationStatus = modelSizeStats.categorizationStatus;
            this.timestamp = modelSizeStats.timestamp;
            this.logTime = modelSizeStats.logTime;
        }

        public Builder setModelBytes(long modelBytes) {
            this.modelBytes = modelBytes;
            return this;
        }

        public Builder setPeakModelBytes(long peakModelBytes) {
            this.peakModelBytes = peakModelBytes;
            return this;
        }

        public Builder setModelBytesExceeded(long modelBytesExceeded) {
            this.modelBytesExceeded = modelBytesExceeded;
            return this;
        }

        public Builder setModelBytesMemoryLimit(long modelBytesMemoryLimit) {
            this.modelBytesMemoryLimit = modelBytesMemoryLimit;
            return this;
        }

        public Builder setTotalByFieldCount(long totalByFieldCount) {
            this.totalByFieldCount = totalByFieldCount;
            return this;
        }

        public Builder setTotalPartitionFieldCount(long totalPartitionFieldCount) {
            this.totalPartitionFieldCount = totalPartitionFieldCount;
            return this;
        }

        public Builder setTotalOverFieldCount(long totalOverFieldCount) {
            this.totalOverFieldCount = totalOverFieldCount;
            return this;
        }

        public Builder setBucketAllocationFailuresCount(long bucketAllocationFailuresCount) {
            this.bucketAllocationFailuresCount = bucketAllocationFailuresCount;
            return this;
        }

        public Builder setMemoryStatus(MemoryStatus memoryStatus) {
            Objects.requireNonNull(memoryStatus, "[" + MEMORY_STATUS_FIELD.getPreferredName() + "] must not be null");
            this.memoryStatus = memoryStatus;
            return this;
        }

        public Builder setAssignmentMemoryBasis(AssignmentMemoryBasis assignmentMemoryBasis) {
            this.assignmentMemoryBasis = assignmentMemoryBasis;
            return this;
        }

        public Builder setOutputMemoryAllocatorBytes(long outputMemoryAllocatorBytes) {
            this.outputMemoryAllocatorBytes = outputMemoryAllocatorBytes;
            return this;
        }

        public Builder setCategorizedDocCount(long categorizedDocCount) {
            this.categorizedDocCount = categorizedDocCount;
            return this;
        }

        public Builder setTotalCategoryCount(long totalCategoryCount) {
            this.totalCategoryCount = totalCategoryCount;
            return this;
        }

        public Builder setFrequentCategoryCount(long frequentCategoryCount) {
            this.frequentCategoryCount = frequentCategoryCount;
            return this;
        }

        public Builder setRareCategoryCount(long rareCategoryCount) {
            this.rareCategoryCount = rareCategoryCount;
            return this;
        }

        public Builder setDeadCategoryCount(long deadCategoryCount) {
            this.deadCategoryCount = deadCategoryCount;
            return this;
        }

        public Builder setFailedCategoryCount(long failedCategoryCount) {
            this.failedCategoryCount = failedCategoryCount;
            return this;
        }

        public Builder setCategorizationStatus(CategorizationStatus categorizationStatus) {
            Objects.requireNonNull(categorizationStatus, "[" + CATEGORIZATION_STATUS_FIELD.getPreferredName() + "] must not be null");
            this.categorizationStatus = categorizationStatus;
            return this;
        }

        public Builder setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setLogTime(Date logTime) {
            this.logTime = logTime;
            return this;
        }

        public ModelSizeStats build() {
            return new ModelSizeStats(this.jobId, this.modelBytes, this.peakModelBytes, this.modelBytesExceeded, this.modelBytesMemoryLimit, this.totalByFieldCount, this.totalOverFieldCount, this.totalPartitionFieldCount, this.bucketAllocationFailuresCount, this.memoryStatus, this.assignmentMemoryBasis, this.outputMemoryAllocatorBytes, this.categorizedDocCount, this.totalCategoryCount, this.frequentCategoryCount, this.rareCategoryCount, this.deadCategoryCount, this.failedCategoryCount, this.categorizationStatus, this.timestamp, this.logTime);
        }
    }
}

