/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.process.autodetect.output;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class FlushAcknowledgement
implements ToXContentObject,
Writeable {
    public static final ParseField TYPE = new ParseField("flush", new String[0]);
    public static final ParseField ID = new ParseField("id", new String[0]);
    public static final ParseField LAST_FINALIZED_BUCKET_END = new ParseField("last_finalized_bucket_end", new String[0]);
    public static final ParseField REFRESH_REQUIRED = new ParseField("refresh_required", new String[0]);
    public static final ConstructingObjectParser<FlushAcknowledgement, Void> PARSER = new ConstructingObjectParser(TYPE.getPreferredName(), a -> new FlushAcknowledgement((String)a[0], (Long)a[1], (Boolean)a[2]));
    private final String id;
    private final Instant lastFinalizedBucketEnd;
    private final boolean refreshRequired;

    public FlushAcknowledgement(String id, Long lastFinalizedBucketEndMs, Boolean refreshRequired) {
        this.id = id;
        this.lastFinalizedBucketEnd = lastFinalizedBucketEndMs != null && lastFinalizedBucketEndMs > 0L ? Instant.ofEpochMilli(lastFinalizedBucketEndMs) : null;
        this.refreshRequired = refreshRequired == null || refreshRequired != false;
    }

    public FlushAcknowledgement(String id, Instant lastFinalizedBucketEnd, Boolean refreshRequired) {
        this.id = id;
        long epochMillis = lastFinalizedBucketEnd != null ? lastFinalizedBucketEnd.toEpochMilli() : 0L;
        this.lastFinalizedBucketEnd = epochMillis > 0L ? Instant.ofEpochMilli(epochMillis) : null;
        this.refreshRequired = refreshRequired == null || refreshRequired != false;
    }

    public FlushAcknowledgement(StreamInput in) throws IOException {
        this.id = in.readString();
        this.lastFinalizedBucketEnd = in.readOptionalInstant();
        this.refreshRequired = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_9_X) ? in.readBoolean() : true;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeOptionalInstant(this.lastFinalizedBucketEnd);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_9_X)) {
            out.writeBoolean(this.refreshRequired);
        }
    }

    public String getId() {
        return this.id;
    }

    public Instant getLastFinalizedBucketEnd() {
        return this.lastFinalizedBucketEnd;
    }

    public boolean getRefreshRequired() {
        return this.refreshRequired;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID.getPreferredName(), this.id);
        if (this.lastFinalizedBucketEnd != null) {
            builder.timeField(LAST_FINALIZED_BUCKET_END.getPreferredName(), LAST_FINALIZED_BUCKET_END.getPreferredName() + "_string", this.lastFinalizedBucketEnd.toEpochMilli());
        }
        builder.field(REFRESH_REQUIRED.getPreferredName(), this.refreshRequired);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.lastFinalizedBucketEnd, this.refreshRequired);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlushAcknowledgement other = (FlushAcknowledgement)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.lastFinalizedBucketEnd, other.lastFinalizedBucketEnd) && this.refreshRequired == other.refreshRequired;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), LAST_FINALIZED_BUCKET_END);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), REFRESH_REQUIRED);
    }
}

