/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelPrefixStrings;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class ModelPackageConfig
implements ToXContentObject,
Writeable {
    public static final ParseField PACKAGED_MODEL_ID = new ParseField("packaged_model_id", new String[0]);
    public static final ParseField MODEL_REPOSITORY = new ParseField("model_repository", new String[0]);
    public static final ParseField MINIMUM_VERSION = new ParseField("minimum_version", new String[0]);
    public static final ParseField CREATE_TIME = new ParseField("create_time", new String[0]);
    public static final ParseField SIZE = new ParseField("size", new String[0]);
    public static final ParseField CHECKSUM_SHA256 = new ParseField("sha256", new String[0]);
    public static final ParseField VOCABULARY_FILE = new ParseField("vocabulary_file", new String[0]);
    public static final ParseField PLATFORM_ARCHITECTURE = new ParseField("platform_architecture", new String[0]);
    private static final ConstructingObjectParser<ModelPackageConfig, Void> LENIENT_PARSER = ModelPackageConfig.createParser(true);
    private static final ConstructingObjectParser<ModelPackageConfig, Void> STRICT_PARSER = ModelPackageConfig.createParser(false);
    private final String packagedModelId;
    private final String modelRepository;
    private final String description;
    private final String minimumVersion;
    private final Instant createTime;
    private final long size;
    private final String sha256;
    private final Map<String, Object> inferenceConfigSource;
    private final Map<String, Object> metadata;
    private final String modelType;
    private final List<String> tags;
    private final String vocabularyFile;
    private final String platformArchitecture;
    private final TrainedModelPrefixStrings prefixStrings;

    private static ConstructingObjectParser<ModelPackageConfig, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(PACKAGED_MODEL_ID.getPreferredName(), lenient, a -> {
            Map inferenceConfigSource = (Map)a[7];
            Map metadata = (Map)a[8];
            List tags = (List)a[10];
            return new ModelPackageConfig((String)a[0], (String)a[1], (String)a[2], (String)a[3], (Instant)a[4], (Long)a[5], (String)a[6], inferenceConfigSource, metadata, (String)a[9], tags, (String)a[11], (String)a[12], (TrainedModelPrefixStrings)a[13]);
        });
        parser.declareString(ConstructingObjectParser.constructorArg(), PACKAGED_MODEL_ID);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), MODEL_REPOSITORY);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), TrainedModelConfig.DESCRIPTION);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), MINIMUM_VERSION);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeUtils.parseTimeFieldToInstant(p, CREATE_TIME.getPreferredName()), CREATE_TIME, ObjectParser.ValueType.VALUE);
        parser.declareLong(ConstructingObjectParser.optionalConstructorArg(), SIZE);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), CHECKSUM_SHA256);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapOrdered(), TrainedModelConfig.INFERENCE_CONFIG);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapOrdered(), TrainedModelConfig.METADATA);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), TrainedModelConfig.MODEL_TYPE);
        parser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), TrainedModelConfig.TAGS);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), VOCABULARY_FILE);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), PLATFORM_ARCHITECTURE);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TrainedModelPrefixStrings.fromXContent(p, lenient), TrainedModelConfig.PREFIX_STRINGS);
        return parser;
    }

    public static ModelPackageConfig fromXContentStrict(XContentParser parser) throws IOException {
        return (ModelPackageConfig)STRICT_PARSER.parse(parser, null);
    }

    public static ModelPackageConfig fromXContentLenient(XContentParser parser) throws IOException {
        return (ModelPackageConfig)LENIENT_PARSER.parse(parser, null);
    }

    public ModelPackageConfig(String packagedModelId, String modelRepository, String description, String minimumVersion, Instant createTime, Long size, String sha256, Map<String, Object> inferenceConfigSource, Map<String, Object> metadata, String modelType, List<String> tags, String vocabularyFile, String platformArchitecture, TrainedModelPrefixStrings prefixStrings) {
        this.packagedModelId = ExceptionsHelper.requireNonNull(packagedModelId, PACKAGED_MODEL_ID);
        this.modelRepository = modelRepository;
        this.description = description;
        this.minimumVersion = minimumVersion;
        this.createTime = createTime;
        long l = this.size = size == null ? 0L : size;
        if (this.size < 0L) {
            throw new IllegalArgumentException("[size] must not be negative.");
        }
        this.sha256 = sha256;
        this.inferenceConfigSource = inferenceConfigSource;
        this.metadata = metadata == null ? Collections.emptyMap() : Collections.unmodifiableMap(metadata);
        this.modelType = modelType;
        this.tags = tags == null ? Collections.emptyList() : Collections.unmodifiableList(tags);
        this.vocabularyFile = vocabularyFile;
        this.platformArchitecture = platformArchitecture;
        this.prefixStrings = prefixStrings;
    }

    public ModelPackageConfig(StreamInput in) throws IOException {
        this.packagedModelId = in.readString();
        this.modelRepository = in.readOptionalString();
        this.description = in.readOptionalString();
        this.minimumVersion = in.readOptionalString();
        this.createTime = in.readOptionalInstant();
        this.size = in.readVLong();
        this.sha256 = in.readOptionalString();
        this.inferenceConfigSource = in.readGenericMap();
        this.metadata = in.readGenericMap();
        this.modelType = in.readOptionalString();
        this.tags = in.readOptionalCollectionAsList(StreamInput::readString);
        this.vocabularyFile = in.readOptionalString();
        this.platformArchitecture = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_11_X) ? in.readOptionalString() : null;
        this.prefixStrings = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0) ? (TrainedModelPrefixStrings)in.readOptionalWriteable(TrainedModelPrefixStrings::new) : null;
    }

    public String getPackagedModelId() {
        return this.packagedModelId;
    }

    public String getModelRepository() {
        return this.modelRepository;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMinimumVersion() {
        return this.minimumVersion;
    }

    public Instant getCreateTime() {
        return this.createTime;
    }

    public long getSize() {
        return this.size;
    }

    public String getSha256() {
        return this.sha256;
    }

    public Map<String, Object> getInferenceConfigSource() {
        return this.inferenceConfigSource;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String getModelType() {
        return this.modelType;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getVocabularyFile() {
        return this.vocabularyFile;
    }

    public String getPlatformArchitecture() {
        return this.platformArchitecture;
    }

    public TrainedModelPrefixStrings getPrefixStrings() {
        return this.prefixStrings;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(PACKAGED_MODEL_ID.getPreferredName(), this.packagedModelId);
        if (!Strings.isNullOrEmpty((String)this.modelRepository)) {
            builder.field(MODEL_REPOSITORY.getPreferredName(), this.modelRepository);
        }
        if (!Strings.isNullOrEmpty((String)this.description)) {
            builder.field(TrainedModelConfig.DESCRIPTION.getPreferredName(), this.description);
        }
        if (!Strings.isNullOrEmpty((String)this.minimumVersion)) {
            builder.field(MINIMUM_VERSION.getPreferredName(), this.minimumVersion);
        }
        if (this.createTime != null) {
            builder.timeField(CREATE_TIME.getPreferredName(), CREATE_TIME.getPreferredName() + "_string", this.createTime.toEpochMilli());
        }
        if (this.size > 0L) {
            builder.field(SIZE.getPreferredName(), this.size);
        }
        if (this.sha256 != null) {
            builder.field(CHECKSUM_SHA256.getPreferredName(), this.sha256);
        }
        if (this.inferenceConfigSource != null) {
            builder.field(TrainedModelConfig.INFERENCE_CONFIG.getPreferredName(), this.inferenceConfigSource);
        }
        if (this.metadata != null) {
            builder.field(TrainedModelConfig.METADATA.getPreferredName(), this.metadata);
        }
        if (!Strings.isNullOrEmpty((String)this.modelType)) {
            builder.field(TrainedModelConfig.MODEL_TYPE.getPreferredName(), this.modelType);
        }
        if (this.tags != null) {
            builder.field(TrainedModelConfig.TAGS.getPreferredName(), this.tags);
        }
        if (!Strings.isNullOrEmpty((String)this.vocabularyFile)) {
            builder.field(VOCABULARY_FILE.getPreferredName(), this.vocabularyFile);
        }
        if (!Strings.isNullOrEmpty((String)this.platformArchitecture)) {
            builder.field(PLATFORM_ARCHITECTURE.getPreferredName(), this.platformArchitecture);
        }
        if (this.prefixStrings != null) {
            builder.field(TrainedModelConfig.PREFIX_STRINGS.getPreferredName(), (ToXContent)this.prefixStrings);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.packagedModelId);
        out.writeOptionalString(this.modelRepository);
        out.writeOptionalString(this.description);
        out.writeOptionalString(this.minimumVersion);
        out.writeOptionalInstant(this.createTime);
        out.writeVLong(this.size);
        out.writeOptionalString(this.sha256);
        out.writeGenericMap(this.inferenceConfigSource);
        out.writeGenericMap(this.metadata);
        out.writeOptionalString(this.modelType);
        out.writeOptionalStringCollection(this.tags);
        out.writeOptionalString(this.vocabularyFile);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_11_X)) {
            out.writeOptionalString(this.platformArchitecture);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0)) {
            out.writeOptionalWriteable((Writeable)this.prefixStrings);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelPackageConfig that = (ModelPackageConfig)o;
        return this.size == that.size && Objects.equals(this.packagedModelId, that.packagedModelId) && Objects.equals(this.modelRepository, that.modelRepository) && Objects.equals(this.description, that.description) && Objects.equals(this.minimumVersion, that.minimumVersion) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.sha256, that.sha256) && Objects.equals(this.inferenceConfigSource, that.inferenceConfigSource) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.modelType, that.modelType) && Objects.equals(this.tags, that.tags) && Objects.equals(this.vocabularyFile, that.vocabularyFile) && Objects.equals(this.platformArchitecture, that.platformArchitecture) && Objects.equals(this.prefixStrings, that.prefixStrings);
    }

    public int hashCode() {
        return Objects.hash(this.packagedModelId, this.modelRepository, this.description, this.minimumVersion, this.createTime, this.size, this.sha256, this.inferenceConfigSource, this.metadata, this.modelType, this.tags, this.vocabularyFile, this.platformArchitecture, this.prefixStrings);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    public static class Builder {
        private String packagedModelId;
        private String modelRepository;
        private Instant createTime;
        private String minimumVersion;
        private String description;
        private long size;
        private String sha256;
        private Map<String, Object> inferenceConfigSource;
        private Map<String, Object> metadata;
        private String modelType;
        private List<String> tags;
        private String vocabularyFile;
        private String platformArchitecture;
        private TrainedModelPrefixStrings prefixStrings;

        public Builder(ModelPackageConfig modelPackageConfig) {
            this.packagedModelId = modelPackageConfig.packagedModelId;
            this.modelRepository = modelPackageConfig.modelRepository;
            this.description = modelPackageConfig.description;
            this.minimumVersion = modelPackageConfig.minimumVersion;
            this.createTime = modelPackageConfig.createTime;
            this.size = modelPackageConfig.size;
            this.sha256 = modelPackageConfig.sha256;
            this.inferenceConfigSource = modelPackageConfig.inferenceConfigSource;
            this.metadata = modelPackageConfig.metadata;
            this.modelType = modelPackageConfig.modelType;
            this.tags = modelPackageConfig.tags;
            this.vocabularyFile = modelPackageConfig.vocabularyFile;
            this.platformArchitecture = modelPackageConfig.platformArchitecture;
            this.prefixStrings = modelPackageConfig.prefixStrings;
        }

        public Builder setPackedModelId(String packagedModelId) {
            this.packagedModelId = packagedModelId;
            return this;
        }

        public Builder setModelRepository(String modelRepository) {
            this.modelRepository = modelRepository;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setMinimumVersion(String minimumVersion) {
            this.minimumVersion = minimumVersion;
            return this;
        }

        public Builder setCreateTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public Builder setSize(long size) {
            this.size = size;
            return this;
        }

        public Builder setSha256(String sha256) {
            this.sha256 = sha256;
            return this;
        }

        public Builder setInferenceConfigSource(Map<String, Object> inferenceConfigSource) {
            this.inferenceConfigSource = inferenceConfigSource;
            return this;
        }

        public Builder setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setModelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        public Builder setTags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder setVocabularyFile(String vocabularyFile) {
            this.vocabularyFile = vocabularyFile;
            return this;
        }

        public Builder setPlatformArchitecture(String platformArchitecture) {
            this.platformArchitecture = platformArchitecture;
            return this;
        }

        public Builder setPrefixStrings(TrainedModelPrefixStrings prefixStrings) {
            this.prefixStrings = prefixStrings;
            return this;
        }

        public Builder resetPackageOnlyFields() {
            this.description = null;
            this.inferenceConfigSource = null;
            this.metadata = null;
            this.modelType = null;
            this.tags = null;
            this.prefixStrings = null;
            return this;
        }

        public ModelPackageConfig build() {
            return new ModelPackageConfig(this.packagedModelId, this.modelRepository, this.description, this.minimumVersion, this.createTime, this.size, this.sha256, this.inferenceConfigSource, this.metadata, this.modelType, this.tags, this.vocabularyFile, this.platformArchitecture, this.prefixStrings);
        }
    }
}

