/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;

public class PutTrainedModelAction
extends ActionType<Response> {
    public static final String DEFER_DEFINITION_DECOMPRESSION = "defer_definition_decompression";
    public static final PutTrainedModelAction INSTANCE = new PutTrainedModelAction();
    public static final String NAME = "cluster:admin/xpack/ml/inference/put";
    public static final String MODEL_ALREADY_EXISTS_ERROR_MESSAGE_FRAGMENT = "the model id is the same as the deployment id of a current model deployment";

    private PutTrainedModelAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final TrainedModelConfig trainedModelConfig;

        public Response(TrainedModelConfig trainedModelConfig) {
            this.trainedModelConfig = trainedModelConfig;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.trainedModelConfig = new TrainedModelConfig(in);
        }

        public TrainedModelConfig getResponse() {
            return this.trainedModelConfig;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.trainedModelConfig.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.trainedModelConfig.toXContent(builder, params);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.trainedModelConfig, response.trainedModelConfig);
        }

        public int hashCode() {
            return Objects.hash(this.trainedModelConfig);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final TrainedModelConfig config;
        private final boolean deferDefinitionDecompression;
        private final boolean waitForCompletion;

        public static Request parseRequest(String modelId, boolean deferDefinitionValidation, boolean waitForCompletion, XContentParser parser) {
            TrainedModelConfig.Builder builder = (TrainedModelConfig.Builder)TrainedModelConfig.STRICT_PARSER.apply(parser, null);
            if (builder.getModelId() == null) {
                builder.setModelId(modelId).build();
            } else if (!Strings.isNullOrEmpty((String)modelId) && !modelId.equals(builder.getModelId())) {
                throw new IllegalArgumentException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", TrainedModelConfig.MODEL_ID.getPreferredName(), builder.getModelId(), modelId));
            }
            return new Request(builder.validate(true).build(), deferDefinitionValidation, waitForCompletion);
        }

        public Request(TrainedModelConfig config, boolean deferDefinitionDecompression) {
            this(config, deferDefinitionDecompression, false);
        }

        public Request(TrainedModelConfig config, boolean deferDefinitionDecompression, boolean waitForCompletion) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
            this.config = config;
            this.deferDefinitionDecompression = deferDefinitionDecompression;
            this.waitForCompletion = waitForCompletion;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.config = new TrainedModelConfig(in);
            this.deferDefinitionDecompression = in.readBoolean();
            this.waitForCompletion = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_8_0) ? in.readBoolean() : false;
        }

        public TrainedModelConfig getTrainedModelConfig() {
            return this.config;
        }

        public ActionRequestValidationException validate() {
            if (this.deferDefinitionDecompression && this.config.getModelSize() == 0L && this.config.getCompressedDefinitionIfSet() != null) {
                ActionRequestValidationException validationException = new ActionRequestValidationException();
                validationException.addValidationError("when [defer_definition_decompression] is true and a compressed definition is provided, " + TrainedModelConfig.MODEL_SIZE_BYTES + " must be set");
                return validationException;
            }
            return null;
        }

        public boolean isDeferDefinitionDecompression() {
            return this.deferDefinitionDecompression;
        }

        public boolean isWaitForCompletion() {
            return this.waitForCompletion;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.config.writeTo(out);
            out.writeBoolean(this.deferDefinitionDecompression);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_8_0)) {
                out.writeBoolean(this.waitForCompletion);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.config, request.config) && this.deferDefinitionDecompression == request.deferDefinitionDecompression && this.waitForCompletion == request.waitForCompletion;
        }

        public int hashCode() {
            return Objects.hash(this.config, this.deferDefinitionDecompression, this.waitForCompletion);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this.config);
        }
    }
}

