/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.results.InferenceTextEmbeddingByteResults;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingUtils;
import org.elasticsearch.xpack.core.ml.inference.results.ChunkedNlpInferenceResults;

public record InferenceChunkedTextEmbeddingByteResults(List<InferenceByteEmbeddingChunk> chunks, boolean isTruncated) implements ChunkedInferenceServiceResults
{
    public static final String NAME = "chunked_text_embedding_service_byte_results";
    public static final String FIELD_NAME = "text_embedding_byte_chunk";

    public InferenceChunkedTextEmbeddingByteResults(StreamInput in) throws IOException {
        this(in.readCollectionAsList(InferenceByteEmbeddingChunk::new), in.readBoolean());
    }

    public static List<ChunkedInferenceServiceResults> listOf(List<String> inputs, InferenceTextEmbeddingByteResults textEmbeddings) {
        TextEmbeddingUtils.validateInputSizeAgainstEmbeddings(inputs, textEmbeddings.embeddings().size());
        ArrayList<ChunkedInferenceServiceResults> results = new ArrayList<ChunkedInferenceServiceResults>(inputs.size());
        for (int i = 0; i < inputs.size(); ++i) {
            results.add(InferenceChunkedTextEmbeddingByteResults.ofSingle(inputs.get(i), textEmbeddings.embeddings().get(i).values()));
        }
        return results;
    }

    private static InferenceChunkedTextEmbeddingByteResults ofSingle(String input, byte[] byteEmbeddings) {
        return new InferenceChunkedTextEmbeddingByteResults(List.of(new InferenceByteEmbeddingChunk(input, byteEmbeddings)), false);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(FIELD_NAME);
        for (InferenceByteEmbeddingChunk embedding : this.chunks) {
            embedding.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.chunks);
        out.writeBoolean(this.isTruncated);
    }

    public List<? extends InferenceResults> transformToCoordinationFormat() {
        throw new UnsupportedOperationException("Chunked results are not returned in the coordinated action");
    }

    public List<? extends InferenceResults> transformToLegacyFormat() {
        throw new UnsupportedOperationException("Chunked results are not returned in the legacy format");
    }

    public Map<String, Object> asMap() {
        return Map.of(FIELD_NAME, this.chunks);
    }

    public String getWriteableName() {
        return NAME;
    }

    public List<InferenceByteEmbeddingChunk> getChunks() {
        return this.chunks;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InferenceChunkedTextEmbeddingByteResults that = (InferenceChunkedTextEmbeddingByteResults)o;
        return this.isTruncated == that.isTruncated && Objects.equals(this.chunks, that.chunks);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.chunks, this.isTruncated);
    }

    public Iterator<ChunkedInferenceServiceResults.Chunk> chunksAsMatchedTextAndByteReference(XContent xcontent) {
        return this.chunks.stream().map(chunk -> new ChunkedInferenceServiceResults.Chunk(chunk.matchedText(), InferenceChunkedTextEmbeddingByteResults.toBytesReference(xcontent, chunk.embedding()))).iterator();
    }

    private static BytesReference toBytesReference(XContent xContent, byte[] value) {
        try {
            XContentBuilder b = XContentBuilder.builder((XContent)xContent);
            b.startArray();
            for (byte v : value) {
                b.value(v);
            }
            b.endArray();
            return BytesReference.bytes((XContentBuilder)b);
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public record InferenceByteEmbeddingChunk(String matchedText, byte[] embedding) implements Writeable,
    ToXContentObject
    {
        public InferenceByteEmbeddingChunk(StreamInput in) throws IOException {
            this(in.readString(), in.readByteArray());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.matchedText);
            out.writeByteArray(this.embedding);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(ChunkedNlpInferenceResults.TEXT, this.matchedText);
            builder.startArray(ChunkedNlpInferenceResults.INFERENCE);
            for (byte value : this.embedding) {
                builder.value(value);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        @Override
        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InferenceByteEmbeddingChunk that = (InferenceByteEmbeddingChunk)o;
            return Objects.equals(this.matchedText, that.matchedText) && Arrays.equals(this.embedding, that.embedding);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.matchedText);
            result = 31 * result + Arrays.hashCode(this.embedding);
            return result;
        }
    }
}

