/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.datastreams;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureSet;

public class DataStreamLifecycleFeatureSetUsage
extends XPackFeatureSet.Usage {
    public static final DataStreamLifecycleFeatureSetUsage DISABLED = new DataStreamLifecycleFeatureSetUsage();
    final LifecycleStats lifecycleStats;

    public DataStreamLifecycleFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        this.lifecycleStats = LifecycleStats.read(input);
    }

    private DataStreamLifecycleFeatureSetUsage() {
        super("data_lifecycle", true, false);
        this.lifecycleStats = LifecycleStats.INITIAL;
    }

    public DataStreamLifecycleFeatureSetUsage(LifecycleStats stats) {
        super("data_lifecycle", true, true);
        this.lifecycleStats = stats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.lifecycleStats.writeTo(out);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_9_X;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        if (this.enabled) {
            builder.field("count", this.lifecycleStats.dataStreamsWithLifecyclesCount);
            builder.field("default_rollover_used", this.lifecycleStats.defaultRolloverUsed);
            builder.startObject("retention");
            builder.field("minimum_millis", this.lifecycleStats.minRetentionMillis);
            builder.field("maximum_millis", this.lifecycleStats.maxRetentionMillis);
            builder.field("average_millis", this.lifecycleStats.averageRetentionMillis);
            builder.endObject();
        }
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public int hashCode() {
        return Objects.hash(this.available, this.enabled, this.lifecycleStats);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DataStreamLifecycleFeatureSetUsage other = (DataStreamLifecycleFeatureSetUsage)obj;
        return this.available == other.available && this.enabled == other.enabled && Objects.equals(this.lifecycleStats, other.lifecycleStats);
    }

    public static class LifecycleStats
    implements Writeable {
        public static final LifecycleStats INITIAL = new LifecycleStats(0L, 0L, 0L, 0.0, true);
        final long dataStreamsWithLifecyclesCount;
        final long minRetentionMillis;
        final long maxRetentionMillis;
        final double averageRetentionMillis;
        final boolean defaultRolloverUsed;

        public LifecycleStats(long dataStreamsWithLifecyclesCount, long minRetention, long maxRetention, double averageRetention, boolean defaultRolloverUsed) {
            this.dataStreamsWithLifecyclesCount = dataStreamsWithLifecyclesCount;
            this.minRetentionMillis = minRetention;
            this.maxRetentionMillis = maxRetention;
            this.averageRetentionMillis = averageRetention;
            this.defaultRolloverUsed = defaultRolloverUsed;
        }

        public static LifecycleStats read(StreamInput in) throws IOException {
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_9_X)) {
                return new LifecycleStats(in.readVLong(), in.readVLong(), in.readVLong(), in.readDouble(), in.readBoolean());
            }
            return INITIAL;
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_9_X)) {
                out.writeVLong(this.dataStreamsWithLifecyclesCount);
                out.writeVLong(this.minRetentionMillis);
                out.writeVLong(this.maxRetentionMillis);
                out.writeDouble(this.averageRetentionMillis);
                out.writeBoolean(this.defaultRolloverUsed);
            }
        }

        public int hashCode() {
            return Objects.hash(this.dataStreamsWithLifecyclesCount, this.minRetentionMillis, this.maxRetentionMillis, this.averageRetentionMillis, this.defaultRolloverUsed);
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            LifecycleStats other = (LifecycleStats)obj;
            return this.dataStreamsWithLifecyclesCount == other.dataStreamsWithLifecyclesCount && this.minRetentionMillis == other.minRetentionMillis && this.maxRetentionMillis == other.maxRetentionMillis && this.averageRetentionMillis == other.averageRetentionMillis && this.defaultRolloverUsed == other.defaultRolloverUsed;
        }
    }
}

