/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.datastreams.DataStreamFeatureSetUsage;

public class DataStreamUsageTransportAction
extends XPackUsageFeatureTransportAction {
    @Inject
    public DataStreamUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(XPackUsageFeatureAction.DATA_STREAMS.name(), transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        Map dataStreams = state.metadata().dataStreams();
        long backingIndicesCounter = 0L;
        long failureStoreEnabledCounter = 0L;
        long failureIndicesCounter = 0L;
        for (DataStream ds : dataStreams.values()) {
            backingIndicesCounter += (long)ds.getIndices().size();
            if (!DataStream.isFailureStoreFeatureFlagEnabled()) continue;
            if (ds.isFailureStoreEnabled()) {
                ++failureStoreEnabledCounter;
            }
            if (ds.getFailureIndices().getIndices().isEmpty()) continue;
            failureIndicesCounter += (long)ds.getFailureIndices().getIndices().size();
        }
        DataStreamFeatureSetUsage.DataStreamStats stats = new DataStreamFeatureSetUsage.DataStreamStats(dataStreams.size(), backingIndicesCounter, failureStoreEnabledCounter, failureIndicesCounter);
        DataStreamFeatureSetUsage usage = new DataStreamFeatureSetUsage(stats);
        listener.onResponse((Object)new XPackUsageFeatureResponse(usage));
    }
}

