/*
 * Decompiled with CFR 0.152.
 */
package com.wdtinc.mapbox_vector_tile.build;

import com.wdtinc.mapbox_vector_tile.encoding.MvtValue;
import com.wdtinc.mapbox_vector_tile.util.JdkUtils;
import java.util.LinkedHashMap;

public final class MvtLayerProps {
    private LinkedHashMap<String, Integer> keys = new LinkedHashMap();
    private LinkedHashMap<Object, Integer> vals = new LinkedHashMap();

    public Integer keyIndex(String k) {
        return this.keys.get(k);
    }

    public Integer valueIndex(Object v) {
        return this.vals.get(v);
    }

    public int addKey(String key) {
        JdkUtils.requireNonNull(key);
        int nextIndex = this.keys.size();
        Integer mapIndex = JdkUtils.putIfAbsent(this.keys, key, nextIndex);
        return mapIndex == null ? nextIndex : mapIndex;
    }

    public int addValue(Object value) {
        JdkUtils.requireNonNull(value);
        if (!MvtValue.isValidPropValue(value)) {
            return -1;
        }
        int nextIndex = this.vals.size();
        Integer mapIndex = JdkUtils.putIfAbsent(this.vals, value, nextIndex);
        return mapIndex == null ? nextIndex : mapIndex;
    }

    public Iterable<String> getKeys() {
        return this.keys.keySet();
    }

    public Iterable<Object> getVals() {
        return this.vals.keySet();
    }
}

