/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.UpdateByQueryAction;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;
import org.elasticsearch.xpack.security.support.SecuritySystemIndices;

public class SecurityMigrations {
    public static final Integer ROLE_METADATA_FLATTENED_MIGRATION_VERSION = 1;
    public static final TreeMap<Integer, SecurityMigration> MIGRATIONS_BY_VERSION = new TreeMap<Integer, 1>(Map.of(ROLE_METADATA_FLATTENED_MIGRATION_VERSION, new SecurityMigration(){
        private static final Logger logger = LogManager.getLogger(SecurityMigration.class);

        @Override
        public void migrate(SecurityIndexManager indexManager, Client client, ActionListener<Void> listener) {
            BoolQueryBuilder filterQuery = new BoolQueryBuilder().filter((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)"role")).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"metadata_flattened"));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)filterQuery).size(0).trackTotalHits(true);
            SearchRequest countRequest = new SearchRequest(new String[]{indexManager.getConcreteIndexName()});
            countRequest.source(searchSourceBuilder);
            client.search(countRequest, ActionListener.wrap(response -> {
                if (response.getHits().getTotalHits().value > 0L) {
                    logger.info("Preparing to migrate [" + response.getHits().getTotalHits().value + "] roles");
                    this.updateRolesByQuery(indexManager, client, filterQuery, listener);
                } else {
                    listener.onResponse(null);
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }

        private void updateRolesByQuery(SecurityIndexManager indexManager, Client client, BoolQueryBuilder filterQuery, ActionListener<Void> listener) {
            UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(new String[]{indexManager.getConcreteIndexName()});
            updateByQueryRequest.setQuery((QueryBuilder)filterQuery);
            updateByQueryRequest.setScript(new Script(ScriptType.INLINE, "painless", "ctx._source.metadata_flattened = ctx._source.metadata", Collections.emptyMap()));
            client.admin().cluster().execute((ActionType)UpdateByQueryAction.INSTANCE, (ActionRequest)updateByQueryRequest, ActionListener.wrap(bulkByScrollResponse -> {
                logger.info("Migrated [" + bulkByScrollResponse.getTotal() + "] roles");
                listener.onResponse(null);
            }, arg_0 -> listener.onFailure(arg_0)));
        }

        @Override
        public Set<NodeFeature> nodeFeaturesRequired() {
            return Set.of(SecuritySystemIndices.SECURITY_ROLES_METADATA_FLATTENED);
        }

        @Override
        public int minMappingVersion() {
            return SecuritySystemIndices.SecurityMainIndexMappingVersion.ADD_REMOTE_CLUSTER_AND_DESCRIPTION_FIELDS.id();
        }
    }));

    public static interface SecurityMigration {
        public void migrate(SecurityIndexManager var1, Client var2, ActionListener<Void> var3);

        public Set<NodeFeature> nodeFeaturesRequired();

        public int minMappingVersion();
    }
}

