/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.operator;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.user.InternalUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.operator.FileOperatorUsersStore;
import org.elasticsearch.xpack.security.operator.OperatorOnlyRegistry;
import org.elasticsearch.xpack.security.operator.OperatorPrivilegesViolation;

public class OperatorPrivileges {
    private static final Logger logger = LogManager.getLogger(OperatorPrivileges.class);
    public static final Setting<Boolean> OPERATOR_PRIVILEGES_ENABLED = Setting.boolSetting((String)"xpack.security.operator_privileges.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final OperatorPrivilegesService NOOP_OPERATOR_PRIVILEGES_SERVICE = new OperatorPrivilegesService(){

        @Override
        public void maybeMarkOperatorUser(Authentication authentication, ThreadContext threadContext) {
        }

        @Override
        public ElasticsearchSecurityException check(Authentication authentication, String action, TransportRequest request, ThreadContext threadContext) {
            return null;
        }

        @Override
        public boolean checkRest(RestHandler restHandler, RestRequest restRequest, RestChannel restChannel, ThreadContext threadContext) {
            return true;
        }

        @Override
        public void maybeInterceptRequest(ThreadContext threadContext, TransportRequest request) {
            if (request instanceof RestoreSnapshotRequest) {
                ((RestoreSnapshotRequest)request).skipOperatorOnlyState(false);
            }
        }
    };

    public static boolean isOperator(ThreadContext threadContext) {
        return "operator".equals(threadContext.getHeader("_security_privilege_category"));
    }

    public static interface OperatorPrivilegesService {
        public void maybeMarkOperatorUser(Authentication var1, ThreadContext var2);

        public ElasticsearchSecurityException check(Authentication var1, String var2, TransportRequest var3, ThreadContext var4);

        public boolean checkRest(RestHandler var1, RestRequest var2, RestChannel var3, ThreadContext var4);

        public void maybeInterceptRequest(ThreadContext var1, TransportRequest var2);
    }

    public static final class DefaultOperatorPrivilegesService
    implements OperatorPrivilegesService {
        private final FileOperatorUsersStore fileOperatorUsersStore;
        private final OperatorOnlyRegistry operatorOnlyRegistry;
        private final XPackLicenseState licenseState;

        public DefaultOperatorPrivilegesService(XPackLicenseState licenseState, FileOperatorUsersStore fileOperatorUsersStore, OperatorOnlyRegistry operatorOnlyRegistry) {
            this.fileOperatorUsersStore = fileOperatorUsersStore;
            this.operatorOnlyRegistry = operatorOnlyRegistry;
            this.licenseState = licenseState;
        }

        @Override
        public void maybeMarkOperatorUser(Authentication authentication, ThreadContext threadContext) {
            User user = authentication.getEffectiveSubject().getUser();
            if (user instanceof InternalUser && !authentication.isRunAs()) {
                if (threadContext.getHeader("_security_privilege_category") == null) {
                    threadContext.putHeader("_security_privilege_category", "operator");
                }
                return;
            }
            if (threadContext.getHeader("_security_privilege_category") != null) {
                return;
            }
            if (!authentication.isRunAs() && this.fileOperatorUsersStore.isOperatorUser(authentication)) {
                logger.debug("Marking user [{}] as an operator", (Object)user);
                threadContext.putHeader("_security_privilege_category", "operator");
            } else {
                threadContext.putHeader("_security_privilege_category", "__empty");
            }
        }

        @Override
        public ElasticsearchSecurityException check(Authentication authentication, String action, TransportRequest request, ThreadContext threadContext) {
            if (!this.shouldProcess()) {
                return null;
            }
            User user = authentication.getEffectiveSubject().getUser();
            if (!OperatorPrivileges.isOperator(threadContext)) {
                logger.trace("Checking operator-only violation for user [{}] and action [{}]", (Object)user, (Object)action);
                OperatorPrivilegesViolation violation = this.operatorOnlyRegistry.check(action, request);
                if (violation != null) {
                    return new ElasticsearchSecurityException("Operator privileges are required for " + violation.message(), new Object[0]);
                }
            }
            return null;
        }

        @Override
        public boolean checkRest(RestHandler restHandler, RestRequest restRequest, RestChannel restChannel, ThreadContext threadContext) {
            if (!this.shouldProcess()) {
                return true;
            }
            if (!OperatorPrivileges.isOperator(threadContext)) {
                if (logger.isTraceEnabled()) {
                    User user = DefaultOperatorPrivilegesService.getUser(threadContext);
                    logger.trace("Checking for any operator-only REST violations for user [{}] and uri [{}]", (Object)user, (Object)restRequest.uri());
                }
                try {
                    this.operatorOnlyRegistry.checkRest(restHandler, restRequest);
                }
                catch (ElasticsearchException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Found the following operator-only violation [{}] for user [{}] and uri [{}]", (Object)e.getMessage(), (Object)DefaultOperatorPrivilegesService.getUser(threadContext), (Object)restRequest.uri());
                    }
                    throw e;
                }
                catch (Exception e) {
                    logger.info("Unexpected exception [{}] while processing operator privileges for user [{}] and uri [{}]", (Object)e.getMessage(), (Object)DefaultOperatorPrivilegesService.getUser(threadContext), (Object)restRequest.uri());
                    throw e;
                }
            }
            return true;
        }

        private static User getUser(ThreadContext threadContext) {
            Authentication authentication = (Authentication)threadContext.getTransient("_xpack_security_authentication");
            return authentication.getEffectiveSubject().getUser();
        }

        @Override
        public void maybeInterceptRequest(ThreadContext threadContext, TransportRequest request) {
            if (request instanceof RestoreSnapshotRequest) {
                logger.debug("Intercepting [{}] for operator privileges", (Object)request);
                ((RestoreSnapshotRequest)request).skipOperatorOnlyState(this.shouldProcess());
            }
        }

        private boolean shouldProcess() {
            return Security.OPERATOR_PRIVILEGES_FEATURE.check(this.licenseState);
        }

        public OperatorOnlyRegistry getOperatorOnlyRegistry() {
            return this.operatorOnlyRegistry;
        }
    }
}

