/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support.mapper;

import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xpack.core.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.core.security.authc.support.mapper.ExpressionRoleMapping;
import org.elasticsearch.xpack.core.security.authz.RoleMappingMetadata;
import org.elasticsearch.xpack.security.authc.support.mapper.AbstractRoleMapperClearRealmCache;

public final class ClusterStateRoleMapper
extends AbstractRoleMapperClearRealmCache
implements ClusterStateListener {
    public static final String CLUSTER_STATE_ROLE_MAPPINGS_ENABLED = "xpack.security.authc.cluster_state_role_mappings.enabled";
    private static final Logger logger = LogManager.getLogger(ClusterStateRoleMapper.class);
    private final ScriptService scriptService;
    private final ClusterService clusterService;
    private final boolean enabled;

    public ClusterStateRoleMapper(Settings settings, ScriptService scriptService, ClusterService clusterService) {
        this.scriptService = scriptService;
        this.clusterService = clusterService;
        this.enabled = settings.getAsBoolean(CLUSTER_STATE_ROLE_MAPPINGS_ENABLED, Boolean.valueOf(false));
        if (this.enabled) {
            clusterService.addListener((ClusterStateListener)this);
        }
    }

    public void resolveRoles(UserRoleMapper.UserData user, ActionListener<Set<String>> listener) {
        listener.onResponse((Object)ExpressionRoleMapping.resolveRoles((UserRoleMapper.UserData)user, this.getMappings(), (ScriptService)this.scriptService, (Logger)logger));
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (this.enabled && !Objects.equals(RoleMappingMetadata.getFromClusterState((ClusterState)event.previousState()), RoleMappingMetadata.getFromClusterState((ClusterState)event.state()))) {
            this.clearRealmCachesOnLocalNode();
        }
    }

    private Set<ExpressionRoleMapping> getMappings() {
        if (!this.enabled) {
            return Set.of();
        }
        return RoleMappingMetadata.getFromClusterState((ClusterState)this.clusterService.state()).getRoleMappings();
    }
}

