/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.security.authc.saml.SamlNameId;
import org.opensaml.saml.saml2.core.Attribute;

public class SamlAttributes {
    public static final String NAMEID_SYNTHENTIC_ATTRIBUTE = "nameid";
    public static final String PERSISTENT_NAMEID_SYNTHENTIC_ATTRIBUTE = "nameid:persistent";
    private final SamlNameId name;
    private final String session;
    private final List<SamlAttribute> attributes;

    SamlAttributes(SamlNameId name, String session, List<SamlAttribute> attributes) {
        this.name = name;
        this.session = session;
        this.attributes = attributes;
    }

    List<String> getAttributeValues(String attributeId) {
        if (Strings.isNullOrEmpty((String)attributeId)) {
            return List.of();
        }
        if (attributeId.equals(NAMEID_SYNTHENTIC_ATTRIBUTE)) {
            return this.name == null ? List.of() : List.of(this.name.value);
        }
        if (attributeId.equals(PERSISTENT_NAMEID_SYNTHENTIC_ATTRIBUTE) && this.name != null && "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent".equals(this.name.format)) {
            return List.of(this.name.value);
        }
        return this.attributes.stream().filter(attr -> attributeId.equals(attr.name) || attributeId.equals(attr.friendlyName)).flatMap(attr -> attr.values.stream()).toList();
    }

    List<SamlAttribute> attributes() {
        return this.attributes;
    }

    SamlNameId name() {
        return this.name;
    }

    String session() {
        return this.session;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.name + ")[" + this.session + "]{" + this.attributes + "}";
    }

    static class SamlAttribute {
        final String name;
        final String friendlyName;
        final List<String> values;

        SamlAttribute(Attribute attribute) {
            this(attribute.getName(), attribute.getFriendlyName(), attribute.getAttributeValues().stream().map(x -> x.getDOM().getTextContent()).filter(Objects::nonNull).toList());
        }

        SamlAttribute(String name, @Nullable String friendlyName, List<String> values) {
            this.name = Objects.requireNonNull(name, "Attribute name cannot be null");
            this.friendlyName = friendlyName;
            this.values = values;
        }

        public String toString() {
            if (Strings.isNullOrEmpty((String)this.friendlyName)) {
                return this.name + "=" + this.values;
            }
            return this.friendlyName + "(" + this.name + ")=" + this.values;
        }
    }
}

