/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.kerberos;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.LoginException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.kerberos.KerberosRealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.core.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.kerberos.KerberosAuthenticationToken;
import org.elasticsearch.xpack.security.authc.kerberos.KerberosTicketValidator;
import org.elasticsearch.xpack.security.authc.support.DelegatedAuthorizationSupport;
import org.ietf.jgss.GSSException;

public final class KerberosRealm
extends Realm
implements CachingRealm {
    public static final String KRB_METADATA_REALM_NAME_KEY = "kerberos_realm";
    public static final String KRB_METADATA_UPN_KEY = "kerberos_user_principal_name";
    private final Cache<String, User> userPrincipalNameToUserCache;
    private final UserRoleMapper userRoleMapper;
    private final KerberosTicketValidator kerberosTicketValidator;
    private final ThreadPool threadPool;
    private final Path keytabPath;
    private final boolean enableKerberosDebug;
    private final boolean removeRealmName;
    private DelegatedAuthorizationSupport delegatedRealms;

    public KerberosRealm(RealmConfig config, UserRoleMapper userRoleMapper, ThreadPool threadPool) {
        this(config, userRoleMapper, new KerberosTicketValidator(), threadPool, null);
    }

    KerberosRealm(RealmConfig config, UserRoleMapper userRoleMapper, KerberosTicketValidator kerberosTicketValidator, ThreadPool threadPool, Cache<String, User> userPrincipalNameToUserCache) {
        super(config);
        this.userRoleMapper = userRoleMapper;
        this.userRoleMapper.clearRealmCacheOnChange((CachingRealm)this);
        TimeValue ttl = (TimeValue)config.getSetting(KerberosRealmSettings.CACHE_TTL_SETTING);
        this.userPrincipalNameToUserCache = ttl.getNanos() > 0L ? (userPrincipalNameToUserCache == null ? CacheBuilder.builder().setExpireAfterWrite((TimeValue)config.getSetting(KerberosRealmSettings.CACHE_TTL_SETTING)).setMaximumWeight((long)((Integer)config.getSetting(KerberosRealmSettings.CACHE_MAX_USERS_SETTING)).intValue()).build() : userPrincipalNameToUserCache) : null;
        this.kerberosTicketValidator = kerberosTicketValidator;
        this.threadPool = threadPool;
        this.keytabPath = config.env().configFile().resolve((String)config.getSetting(KerberosRealmSettings.HTTP_SERVICE_KEYTAB_PATH));
        if (!Files.exists(this.keytabPath, new LinkOption[0])) {
            throw new IllegalArgumentException("configured service key tab file [" + this.keytabPath + "] does not exist");
        }
        if (Files.isDirectory(this.keytabPath, new LinkOption[0])) {
            throw new IllegalArgumentException("configured service key tab file [" + this.keytabPath + "] is a directory");
        }
        if (!Files.isReadable(this.keytabPath)) {
            throw new IllegalArgumentException("configured service key tab file [" + this.keytabPath + "] must have read permission");
        }
        this.enableKerberosDebug = (Boolean)config.getSetting(KerberosRealmSettings.SETTING_KRB_DEBUG_ENABLE);
        this.removeRealmName = (Boolean)config.getSetting(KerberosRealmSettings.SETTING_REMOVE_REALM_NAME);
        this.delegatedRealms = null;
    }

    public void initialize(Iterable<Realm> realms, XPackLicenseState licenseState) {
        if (this.delegatedRealms != null) {
            throw new IllegalStateException("Realm has already been initialized");
        }
        this.delegatedRealms = new DelegatedAuthorizationSupport(realms, this.config, licenseState);
    }

    public Map<String, List<String>> getAuthenticationFailureHeaders() {
        return Collections.singletonMap("WWW-Authenticate", Collections.singletonList("Negotiate"));
    }

    public void expire(String username) {
        if (this.userPrincipalNameToUserCache != null) {
            this.userPrincipalNameToUserCache.invalidate((Object)username);
        }
    }

    public void expireAll() {
        if (this.userPrincipalNameToUserCache != null) {
            this.userPrincipalNameToUserCache.invalidateAll();
        }
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof KerberosAuthenticationToken;
    }

    public AuthenticationToken token(ThreadContext context) {
        return KerberosAuthenticationToken.extractToken(context.getHeader("Authorization"));
    }

    public void authenticate(AuthenticationToken token, ActionListener<AuthenticationResult<User>> listener) {
        assert (this.delegatedRealms != null) : "Realm has not been initialized correctly";
        assert (token instanceof KerberosAuthenticationToken);
        KerberosAuthenticationToken kerbAuthnToken = (KerberosAuthenticationToken)token;
        this.kerberosTicketValidator.validateTicket((byte[])kerbAuthnToken.credentials(), this.keytabPath, this.enableKerberosDebug, (ActionListener<Tuple<String, String>>)ActionListener.wrap(userPrincipalNameOutToken -> {
            if (userPrincipalNameOutToken.v1() != null) {
                this.resolveUser((String)userPrincipalNameOutToken.v1(), (String)userPrincipalNameOutToken.v2(), listener);
            } else {
                String errorMessage = "failed to authenticate user, gss context negotiation not complete";
                ElasticsearchSecurityException ese = KerberosAuthenticationToken.unauthorized(errorMessage, null, new Object[0]);
                ese = KerberosAuthenticationToken.unauthorizedWithOutputToken(ese, (String)userPrincipalNameOutToken.v2());
                listener.onResponse((Object)AuthenticationResult.terminate((String)errorMessage, (Exception)((Object)ese)));
            }
        }, e -> this.handleException((Exception)e, listener)));
    }

    private static String[] splitUserPrincipalName(String userPrincipalName) {
        return userPrincipalName.split("@");
    }

    private void handleException(Exception e, ActionListener<AuthenticationResult<User>> listener) {
        if (e instanceof LoginException) {
            this.logger.debug("failed to authenticate user, service login failure", (Throwable)e);
            listener.onResponse((Object)AuthenticationResult.terminate((String)"failed to authenticate user, service login failure", (Exception)((Object)KerberosAuthenticationToken.unauthorized(e.getLocalizedMessage(), e, new Object[0]))));
        } else if (e instanceof GSSException) {
            this.logger.debug("failed to authenticate user, gss context negotiation failure", (Throwable)e);
            listener.onResponse((Object)AuthenticationResult.terminate((String)"failed to authenticate user, gss context negotiation failure", (Exception)((Object)KerberosAuthenticationToken.unauthorized(e.getLocalizedMessage(), e, new Object[0]))));
        } else {
            this.logger.debug("failed to authenticate user", (Throwable)e);
            listener.onFailure(e);
        }
    }

    private void resolveUser(String userPrincipalName, String outToken, ActionListener<AuthenticationResult<User>> listener) {
        String username;
        if (Strings.hasText((String)outToken)) {
            this.threadPool.getThreadContext().addResponseHeader("WWW-Authenticate", "Negotiate " + outToken);
        }
        String[] userAndRealmName = KerberosRealm.splitUserPrincipalName(userPrincipalName);
        String string = username = this.removeRealmName ? userAndRealmName[0] : userPrincipalName;
        if (this.delegatedRealms.hasDelegation()) {
            this.delegatedRealms.resolve(username, listener);
        } else {
            User user;
            User user2 = user = this.userPrincipalNameToUserCache != null ? (User)this.userPrincipalNameToUserCache.get((Object)username) : null;
            if (user != null) {
                listener.onResponse((Object)AuthenticationResult.success((Object)user));
            } else if (userAndRealmName.length > 1) {
                String realmName = userAndRealmName[1];
                this.buildUser(username, Map.of(KRB_METADATA_REALM_NAME_KEY, realmName, KRB_METADATA_UPN_KEY, userPrincipalName), listener);
            } else {
                this.buildUser(username, Map.of(KRB_METADATA_UPN_KEY, userPrincipalName), listener);
            }
        }
    }

    private void buildUser(String username, Map<String, Object> metadata, ActionListener<AuthenticationResult<User>> listener) {
        UserRoleMapper.UserData userData = new UserRoleMapper.UserData(username, null, Set.of(), metadata, this.config);
        this.userRoleMapper.resolveRoles(userData, ActionListener.wrap(roles -> {
            User computedUser = new User(username, roles.toArray(new String[roles.size()]), null, null, userData.getMetadata(), true);
            if (this.userPrincipalNameToUserCache != null) {
                this.userPrincipalNameToUserCache.put((Object)username, (Object)computedUser);
            }
            listener.onResponse((Object)AuthenticationResult.success((Object)computedUser));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void lookupUser(String username, ActionListener<User> listener) {
        listener.onResponse(null);
    }
}

