/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.audit;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.http.HttpPreRequest;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.audit.AuditLevel;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.transport.filter.SecurityIpFilterRule;

public class AuditTrailService {
    private static final Logger logger = LogManager.getLogger(AuditTrailService.class);
    private static final AuditTrail NOOP_AUDIT_TRAIL = new NoopAuditTrail();
    @Nullable
    private final AuditTrail auditTrail;
    private final XPackLicenseState licenseState;
    private final Duration minLogPeriod = Duration.ofMinutes(30L);
    protected AtomicReference<Instant> nextLogInstantAtomic = new AtomicReference<Instant>(Instant.EPOCH);

    public AuditTrailService(@Nullable AuditTrail auditTrail, XPackLicenseState licenseState) {
        this.auditTrail = auditTrail;
        this.licenseState = licenseState;
    }

    public AuditTrail get() {
        if (this.auditTrail != null) {
            if (Security.AUDITING_FEATURE.check(this.licenseState)) {
                return this.auditTrail;
            }
            this.maybeLogAuditingDisabled();
            return NOOP_AUDIT_TRAIL;
        }
        return NOOP_AUDIT_TRAIL;
    }

    public AuditTrail getAuditTrail() {
        return this.auditTrail;
    }

    private void maybeLogAuditingDisabled() {
        Instant nowInstant = Instant.now();
        Instant nextLogInstant = this.nextLogInstantAtomic.get();
        if (nextLogInstant.isBefore(nowInstant) && this.nextLogInstantAtomic.compareAndSet(nextLogInstant, nowInstant.plus(this.minLogPeriod))) {
            logger.warn("Auditing logging is DISABLED because the currently active license [" + this.licenseState.getOperationMode() + "] does not permit it");
        }
    }

    private static class NoopAuditTrail
    implements AuditTrail {
        private NoopAuditTrail() {
        }

        @Override
        public String name() {
            return "noop";
        }

        @Override
        public void authenticationSuccess(RestRequest request) {
        }

        @Override
        public void authenticationSuccess(String requestId, Authentication authentication, String action, TransportRequest transportRequest) {
        }

        @Override
        public void anonymousAccessDenied(String requestId, String action, TransportRequest transportRequest) {
        }

        @Override
        public void anonymousAccessDenied(String requestId, HttpPreRequest request) {
        }

        @Override
        public void authenticationFailed(String requestId, HttpPreRequest request) {
        }

        @Override
        public void authenticationFailed(String requestId, String action, TransportRequest transportRequest) {
        }

        @Override
        public void authenticationFailed(String requestId, AuthenticationToken token, String action, TransportRequest transportRequest) {
        }

        @Override
        public void authenticationFailed(String requestId, AuthenticationToken token, HttpPreRequest request) {
        }

        @Override
        public void authenticationFailed(String requestId, String realm, AuthenticationToken token, String action, TransportRequest transportRequest) {
        }

        @Override
        public void authenticationFailed(String requestId, String realm, AuthenticationToken token, HttpPreRequest request) {
        }

        @Override
        public void accessGranted(String requestId, Authentication authentication, String action, TransportRequest transportRequest, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        }

        @Override
        public void accessDenied(String requestId, Authentication authentication, String action, TransportRequest transportRequest, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        }

        @Override
        public void tamperedRequest(String requestId, HttpPreRequest request) {
        }

        @Override
        public void tamperedRequest(String requestId, String action, TransportRequest transportRequest) {
        }

        @Override
        public void tamperedRequest(String requestId, Authentication authentication, String action, TransportRequest transportRequest) {
        }

        @Override
        public void connectionGranted(InetSocketAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        }

        @Override
        public void connectionDenied(InetSocketAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        }

        @Override
        public void runAsGranted(String requestId, Authentication authentication, String action, TransportRequest transportRequest, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        }

        @Override
        public void runAsDenied(String requestId, Authentication authentication, String action, TransportRequest transportRequest, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        }

        @Override
        public void runAsDenied(String requestId, Authentication authentication, HttpPreRequest request, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        }

        @Override
        public void explicitIndexAccessEvent(String requestId, AuditLevel eventType, Authentication authentication, String action, String[] indices, String requestName, InetSocketAddress remoteAddress, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        }

        @Override
        public void coordinatingActionResponse(String requestId, Authentication authentication, String action, TransportRequest transportRequest, TransportResponse transportResponse) {
        }
    }
}

