/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.ActionTypes;
import org.elasticsearch.xpack.core.security.action.profile.Profile;
import org.elasticsearch.xpack.core.security.action.user.QueryUserRequest;
import org.elasticsearch.xpack.core.security.action.user.QueryUserResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.profile.ProfileService;
import org.elasticsearch.xpack.security.support.FieldNameTranslators;
import org.elasticsearch.xpack.security.support.UserBoolQueryBuilder;

public final class TransportQueryUserAction
extends TransportAction<QueryUserRequest, QueryUserResponse> {
    private final NativeUsersStore usersStore;
    private final ProfileService profileService;
    private final Authentication.RealmRef nativeRealmRef;

    @Inject
    public TransportQueryUserAction(TransportService transportService, ActionFilters actionFilters, NativeUsersStore usersStore, ProfileService profileService, Realms realms) {
        super(ActionTypes.QUERY_USER_ACTION.name(), actionFilters, transportService.getTaskManager());
        this.usersStore = usersStore;
        this.profileService = profileService;
        this.nativeRealmRef = realms.getNativeRealmRef();
    }

    protected void doExecute(Task task, QueryUserRequest request, ActionListener<QueryUserResponse> listener) {
        SearchSourceBuilder searchSourceBuilder = SearchSourceBuilder.searchSource().version(Boolean.valueOf(false)).fetchSource(true).trackTotalHits(true);
        if (request.getFrom() != null) {
            searchSourceBuilder.from(request.getFrom().intValue());
        }
        if (request.getSize() != null) {
            searchSourceBuilder.size(request.getSize().intValue());
        }
        searchSourceBuilder.query((QueryBuilder)UserBoolQueryBuilder.build(request.getQueryBuilder()));
        if (request.getFieldSortBuilders() != null) {
            FieldNameTranslators.USER_FIELD_NAME_TRANSLATORS.translateFieldSortBuilders(request.getFieldSortBuilders(), searchSourceBuilder, null);
        }
        if (request.getSearchAfterBuilder() != null) {
            searchSourceBuilder.searchAfter(request.getSearchAfterBuilder().getSortValues());
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{".security"}, searchSourceBuilder);
        this.usersStore.queryUsers(searchRequest, (ActionListener<NativeUsersStore.QueryUserResults>)ActionListener.wrap(queryUserResults -> {
            if (request.isWithProfileUid()) {
                this.resolveProfileUids((NativeUsersStore.QueryUserResults)queryUserResults, listener);
            } else {
                List<QueryUserResponse.Item> queryUserResponseResults = queryUserResults.userQueryResult().stream().map(queryUserResult -> new QueryUserResponse.Item(queryUserResult.user(), queryUserResult.sortValues(), null)).toList();
                listener.onResponse((Object)new QueryUserResponse(queryUserResults.total(), queryUserResponseResults));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void resolveProfileUids(NativeUsersStore.QueryUserResults queryUserResults, ActionListener<QueryUserResponse> listener) {
        List<Subject> subjects = queryUserResults.userQueryResult().stream().map(item -> new Subject(item.user(), this.nativeRealmRef)).toList();
        this.profileService.searchProfilesForSubjects(subjects, (ActionListener<ProfileService.SubjectSearchResultsAndErrors<Profile>>)ActionListener.wrap(resultsAndErrors -> {
            if (resultsAndErrors == null || resultsAndErrors.errors().isEmpty()) {
                Map profileUidLookup = resultsAndErrors == null ? Map.of() : resultsAndErrors.results().stream().filter(t -> Objects.nonNull(t.v2())).map(t -> new Tuple((Object)((Subject)t.v1()).getUser().principal(), (Object)((Profile)t.v2()).uid())).collect(Collectors.toUnmodifiableMap(Tuple::v1, Tuple::v2));
                List<QueryUserResponse.Item> queryUserResponseResults = queryUserResults.userQueryResult().stream().map(userResult -> new QueryUserResponse.Item(userResult.user(), userResult.sortValues(), (String)profileUidLookup.getOrDefault(userResult.user().principal(), null))).toList();
                listener.onResponse((Object)new QueryUserResponse(queryUserResults.total(), queryUserResponseResults));
            } else {
                ElasticsearchStatusException exception = new ElasticsearchStatusException("failed to retrieve profile for users. please retry without fetching profile uid (with_profile_uid=false)", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
                resultsAndErrors.errors().values().forEach(arg_0 -> exception.addSuppressed(arg_0));
                listener.onFailure((Exception)exception);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

