/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.saml;

import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.saml.SamlCompleteLogoutRequest;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.saml.SamlLogoutResponseHandler;
import org.elasticsearch.xpack.security.authc.saml.SamlRealm;
import org.elasticsearch.xpack.security.authc.saml.SamlUtils;

public final class TransportSamlCompleteLogoutAction
extends HandledTransportAction<SamlCompleteLogoutRequest, ActionResponse.Empty> {
    public static final ActionType<ActionResponse.Empty> TYPE = new ActionType("cluster:admin/xpack/security/saml/complete_logout");
    private final Realms realms;

    @Inject
    public TransportSamlCompleteLogoutAction(TransportService transportService, ActionFilters actionFilters, Realms realms) {
        super(TYPE.name(), transportService, actionFilters, SamlCompleteLogoutRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.realms = realms;
    }

    protected void doExecute(Task task, SamlCompleteLogoutRequest request, ActionListener<ActionResponse.Empty> listener) {
        List<SamlRealm> realms = SamlRealm.findSamlRealms(this.realms, request.getRealm(), null);
        if (realms.isEmpty()) {
            listener.onFailure((Exception)((Object)SamlUtils.samlException("Cannot find any matching realm with name [{}]", request.getRealm())));
        } else if (realms.size() > 1) {
            listener.onFailure((Exception)((Object)SamlUtils.samlException("Found multiple matching realms [{}] with name [{}]", realms, request.getRealm())));
        } else {
            TransportSamlCompleteLogoutAction.processLogoutResponse(realms.get(0), request, listener);
        }
    }

    private static void processLogoutResponse(SamlRealm samlRealm, SamlCompleteLogoutRequest request, ActionListener<ActionResponse.Empty> listener) {
        SamlLogoutResponseHandler logoutResponseHandler = samlRealm.getLogoutResponseHandler();
        try {
            logoutResponseHandler.handle(request.isHttpRedirect(), request.getPayload(), request.getValidRequestIds());
            listener.onResponse((Object)ActionResponse.Empty.INSTANCE);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

