/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.role;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.role.PutRoleRequest;
import org.elasticsearch.xpack.core.security.action.role.PutRoleResponse;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;

public class TransportPutRoleAction
extends TransportAction<PutRoleRequest, PutRoleResponse> {
    private final NativeRolesStore rolesStore;

    @Inject
    public TransportPutRoleAction(ActionFilters actionFilters, NativeRolesStore rolesStore, TransportService transportService) {
        super("cluster:admin/xpack/security/role/put", actionFilters, transportService.getTaskManager());
        this.rolesStore = rolesStore;
    }

    protected void doExecute(Task task, PutRoleRequest request, ActionListener<PutRoleResponse> listener) {
        this.rolesStore.putRole(request.getRefreshPolicy(), request.roleDescriptor(), (ActionListener<Boolean>)listener.safeMap(created -> {
            if (created.booleanValue()) {
                this.logger.info("added role [{}]", (Object)request.name());
            } else {
                this.logger.info("updated role [{}]", (Object)request.name());
            }
            return new PutRoleResponse(created.booleanValue());
        }));
    }
}

