/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.role;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.ActionTypes;
import org.elasticsearch.xpack.core.security.action.role.BulkPutRolesRequest;
import org.elasticsearch.xpack.core.security.action.role.BulkRolesResponse;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;

public class TransportBulkPutRolesAction
extends TransportAction<BulkPutRolesRequest, BulkRolesResponse> {
    private final NativeRolesStore rolesStore;

    @Inject
    public TransportBulkPutRolesAction(ActionFilters actionFilters, NativeRolesStore rolesStore, TransportService transportService) {
        super(ActionTypes.BULK_PUT_ROLES.name(), actionFilters, transportService.getTaskManager());
        this.rolesStore = rolesStore;
    }

    protected void doExecute(Task task, BulkPutRolesRequest request, ActionListener<BulkRolesResponse> listener) {
        this.rolesStore.putRoles(request.getRefreshPolicy(), request.getRoles(), listener);
    }
}

