/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.role;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.ActionTypes;
import org.elasticsearch.xpack.core.security.action.role.BulkDeleteRolesRequest;
import org.elasticsearch.xpack.core.security.action.role.BulkRolesResponse;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;

public class TransportBulkDeleteRolesAction
extends TransportAction<BulkDeleteRolesRequest, BulkRolesResponse> {
    private final NativeRolesStore rolesStore;

    @Inject
    public TransportBulkDeleteRolesAction(ActionFilters actionFilters, NativeRolesStore rolesStore, TransportService transportService) {
        super(ActionTypes.BULK_DELETE_ROLES.name(), actionFilters, transportService.getTaskManager());
        this.rolesStore = rolesStore;
    }

    protected void doExecute(Task task, BulkDeleteRolesRequest request, ActionListener<BulkRolesResponse> listener) {
        this.rolesStore.deleteRoles(request.getRoleNames(), request.getRefreshPolicy(), listener);
    }
}

