/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.apikey;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.apikey.BaseUpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.BulkUpdateApiKeyResponse;
import org.elasticsearch.xpack.core.security.action.apikey.UpdateApiKeyResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;

public abstract class TransportBaseUpdateApiKeyAction<Request extends BaseUpdateApiKeyRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    private final SecurityContext securityContext;

    protected TransportBaseUpdateApiKeyAction(String actionName, TransportService transportService, ActionFilters actionFilters, SecurityContext context) {
        super(actionName, actionFilters, transportService.getTaskManager());
        this.securityContext = context;
    }

    public final void doExecute(Task task, Request request, ActionListener<Response> listener) {
        Authentication authentication = this.securityContext.getAuthentication();
        if (authentication == null) {
            listener.onFailure((Exception)new IllegalStateException("authentication is required"));
            return;
        }
        if (authentication.isApiKey()) {
            listener.onFailure((Exception)new IllegalArgumentException("authentication via API key not supported: only the owner user can update an API key"));
            return;
        }
        this.doExecuteUpdate(task, request, authentication, listener);
    }

    abstract void doExecuteUpdate(Task var1, Request var2, Authentication var3, ActionListener<Response> var4);

    protected static UpdateApiKeyResponse toSingleResponse(String apiKeyId, BulkUpdateApiKeyResponse response) throws Exception {
        if (response.getTotalResultCount() != 1) {
            throw new IllegalStateException("single result required for single API key update but result count was [" + response.getTotalResultCount() + "]");
        }
        if (!response.getErrorDetails().isEmpty()) {
            Map.Entry errorEntry = response.getErrorDetails().entrySet().iterator().next();
            if (!((String)errorEntry.getKey()).equals(apiKeyId)) {
                TransportBaseUpdateApiKeyAction.throwIllegalStateExceptionOnIdMismatch(apiKeyId, (String)errorEntry.getKey());
            }
            throw (Exception)errorEntry.getValue();
        }
        if (!response.getUpdated().isEmpty()) {
            String updatedId = (String)response.getUpdated().get(0);
            if (!updatedId.equals(apiKeyId)) {
                TransportBaseUpdateApiKeyAction.throwIllegalStateExceptionOnIdMismatch(apiKeyId, updatedId);
            }
            return new UpdateApiKeyResponse(true);
        }
        String noopId = (String)response.getNoops().get(0);
        if (!noopId.equals(apiKeyId)) {
            TransportBaseUpdateApiKeyAction.throwIllegalStateExceptionOnIdMismatch(apiKeyId, noopId);
        }
        return new UpdateApiKeyResponse(false);
    }

    private static void throwIllegalStateExceptionOnIdMismatch(String requestId, String responseId) {
        String message = "response ID [" + responseId + "] does not match request ID [" + requestId + "] for single API key update";
        assert (false) : message;
        throw new IllegalStateException(message);
    }
}

